// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Net;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Required inbound or outbound traffic for Azure Spring Apps resource. </summary>
    public partial class AppPlatformServiceRequiredTraffic
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppPlatformServiceRequiredTraffic"/>. </summary>
        internal AppPlatformServiceRequiredTraffic()
        {
            IPs = new ChangeTrackingList<IPAddress>();
            Fqdns = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatformServiceRequiredTraffic"/>. </summary>
        /// <param name="protocol"> The protocol of required traffic. </param>
        /// <param name="port"> The port of required traffic. </param>
        /// <param name="ips"> The ip list of required traffic. </param>
        /// <param name="fqdns"> The FQDN list of required traffic. </param>
        /// <param name="direction"> The direction of required traffic. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppPlatformServiceRequiredTraffic(string protocol, int? port, IReadOnlyList<IPAddress> ips, IReadOnlyList<string> fqdns, AppPlatformServiceTrafficDirection? direction, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Protocol = protocol;
            Port = port;
            IPs = ips;
            Fqdns = fqdns;
            Direction = direction;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The protocol of required traffic. </summary>
        public string Protocol { get; }
        /// <summary> The port of required traffic. </summary>
        public int? Port { get; }
        /// <summary> The ip list of required traffic. </summary>
        public IReadOnlyList<IPAddress> IPs { get; }
        /// <summary> The FQDN list of required traffic. </summary>
        public IReadOnlyList<string> Fqdns { get; }
        /// <summary> The direction of required traffic. </summary>
        public AppPlatformServiceTrafficDirection? Direction { get; }
    }
}
