// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> State of the Service Registry. </summary>
    public readonly partial struct AppPlatformServiceRegistryProvisioningState : IEquatable<AppPlatformServiceRegistryProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppPlatformServiceRegistryProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppPlatformServiceRegistryProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string DeletingValue = "Deleting";

        /// <summary> Creating. </summary>
        public static AppPlatformServiceRegistryProvisioningState Creating { get; } = new AppPlatformServiceRegistryProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static AppPlatformServiceRegistryProvisioningState Updating { get; } = new AppPlatformServiceRegistryProvisioningState(UpdatingValue);
        /// <summary> Succeeded. </summary>
        public static AppPlatformServiceRegistryProvisioningState Succeeded { get; } = new AppPlatformServiceRegistryProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static AppPlatformServiceRegistryProvisioningState Failed { get; } = new AppPlatformServiceRegistryProvisioningState(FailedValue);
        /// <summary> Deleting. </summary>
        public static AppPlatformServiceRegistryProvisioningState Deleting { get; } = new AppPlatformServiceRegistryProvisioningState(DeletingValue);
        /// <summary> Determines if two <see cref="AppPlatformServiceRegistryProvisioningState"/> values are the same. </summary>
        public static bool operator ==(AppPlatformServiceRegistryProvisioningState left, AppPlatformServiceRegistryProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppPlatformServiceRegistryProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(AppPlatformServiceRegistryProvisioningState left, AppPlatformServiceRegistryProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppPlatformServiceRegistryProvisioningState"/>. </summary>
        public static implicit operator AppPlatformServiceRegistryProvisioningState(string value) => new AppPlatformServiceRegistryProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppPlatformServiceRegistryProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppPlatformServiceRegistryProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
