// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Provisioning state of the Service. </summary>
    public readonly partial struct AppPlatformServiceProvisioningState : IEquatable<AppPlatformServiceProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppPlatformServiceProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppPlatformServiceProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string StartingValue = "Starting";
        private const string StoppingValue = "Stopping";
        private const string DeletingValue = "Deleting";
        private const string DeletedValue = "Deleted";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string MovingValue = "Moving";
        private const string MovedValue = "Moved";
        private const string MoveFailedValue = "MoveFailed";

        /// <summary> Creating. </summary>
        public static AppPlatformServiceProvisioningState Creating { get; } = new AppPlatformServiceProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static AppPlatformServiceProvisioningState Updating { get; } = new AppPlatformServiceProvisioningState(UpdatingValue);
        /// <summary> Starting. </summary>
        public static AppPlatformServiceProvisioningState Starting { get; } = new AppPlatformServiceProvisioningState(StartingValue);
        /// <summary> Stopping. </summary>
        public static AppPlatformServiceProvisioningState Stopping { get; } = new AppPlatformServiceProvisioningState(StoppingValue);
        /// <summary> Deleting. </summary>
        public static AppPlatformServiceProvisioningState Deleting { get; } = new AppPlatformServiceProvisioningState(DeletingValue);
        /// <summary> Deleted. </summary>
        public static AppPlatformServiceProvisioningState Deleted { get; } = new AppPlatformServiceProvisioningState(DeletedValue);
        /// <summary> Succeeded. </summary>
        public static AppPlatformServiceProvisioningState Succeeded { get; } = new AppPlatformServiceProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static AppPlatformServiceProvisioningState Failed { get; } = new AppPlatformServiceProvisioningState(FailedValue);
        /// <summary> Moving. </summary>
        public static AppPlatformServiceProvisioningState Moving { get; } = new AppPlatformServiceProvisioningState(MovingValue);
        /// <summary> Moved. </summary>
        public static AppPlatformServiceProvisioningState Moved { get; } = new AppPlatformServiceProvisioningState(MovedValue);
        /// <summary> MoveFailed. </summary>
        public static AppPlatformServiceProvisioningState MoveFailed { get; } = new AppPlatformServiceProvisioningState(MoveFailedValue);
        /// <summary> Determines if two <see cref="AppPlatformServiceProvisioningState"/> values are the same. </summary>
        public static bool operator ==(AppPlatformServiceProvisioningState left, AppPlatformServiceProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppPlatformServiceProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(AppPlatformServiceProvisioningState left, AppPlatformServiceProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppPlatformServiceProvisioningState"/>. </summary>
        public static implicit operator AppPlatformServiceProvisioningState(string value) => new AppPlatformServiceProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppPlatformServiceProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppPlatformServiceProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
