// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Service properties payload. </summary>
    public partial class AppPlatformServiceProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppPlatformServiceProperties"/>. </summary>
        public AppPlatformServiceProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatformServiceProperties"/>. </summary>
        /// <param name="provisioningState"> Provisioning state of the Service. </param>
        /// <param name="networkProfile"> Network profile of the Service. </param>
        /// <param name="vnetAddons"> Additional Service settings in vnet injection instance. </param>
        /// <param name="version"> Version of the Service. </param>
        /// <param name="serviceInstanceId"> ServiceInstanceEntity GUID which uniquely identifies a created resource. </param>
        /// <param name="powerState"> Power state of the Service. </param>
        /// <param name="isZoneRedundant"></param>
        /// <param name="fqdn"> Fully qualified dns name of the service instance. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppPlatformServiceProperties(AppPlatformServiceProvisioningState? provisioningState, AppPlatformServiceNetworkProfile networkProfile, ServiceVnetAddons vnetAddons, int? version, string serviceInstanceId, AppPlatformServicePowerState? powerState, bool? isZoneRedundant, string fqdn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            NetworkProfile = networkProfile;
            VnetAddons = vnetAddons;
            Version = version;
            ServiceInstanceId = serviceInstanceId;
            PowerState = powerState;
            IsZoneRedundant = isZoneRedundant;
            Fqdn = fqdn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Provisioning state of the Service. </summary>
        public AppPlatformServiceProvisioningState? ProvisioningState { get; }
        /// <summary> Network profile of the Service. </summary>
        public AppPlatformServiceNetworkProfile NetworkProfile { get; set; }
        /// <summary> Additional Service settings in vnet injection instance. </summary>
        internal ServiceVnetAddons VnetAddons { get; set; }
        /// <summary> Indicates whether the log stream in vnet injection instance could be accessed from internet. </summary>
        public bool? IsLogStreamPublicEndpoint
        {
            get => VnetAddons is null ? default : VnetAddons.IsLogStreamPublicEndpoint;
            set
            {
                if (VnetAddons is null)
                    VnetAddons = new ServiceVnetAddons();
                VnetAddons.IsLogStreamPublicEndpoint = value;
            }
        }

        /// <summary> Version of the Service. </summary>
        public int? Version { get; }
        /// <summary> ServiceInstanceEntity GUID which uniquely identifies a created resource. </summary>
        public string ServiceInstanceId { get; }
        /// <summary> Power state of the Service. </summary>
        public AppPlatformServicePowerState? PowerState { get; }
        /// <summary> Gets or sets the is zone redundant. </summary>
        public bool? IsZoneRedundant { get; set; }
        /// <summary> Fully qualified dns name of the service instance. </summary>
        public string Fqdn { get; }
    }
}
