// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Power state of the Service. </summary>
    public readonly partial struct AppPlatformServicePowerState : IEquatable<AppPlatformServicePowerState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppPlatformServicePowerState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppPlatformServicePowerState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RunningValue = "Running";
        private const string StoppedValue = "Stopped";

        /// <summary> Running. </summary>
        public static AppPlatformServicePowerState Running { get; } = new AppPlatformServicePowerState(RunningValue);
        /// <summary> Stopped. </summary>
        public static AppPlatformServicePowerState Stopped { get; } = new AppPlatformServicePowerState(StoppedValue);
        /// <summary> Determines if two <see cref="AppPlatformServicePowerState"/> values are the same. </summary>
        public static bool operator ==(AppPlatformServicePowerState left, AppPlatformServicePowerState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppPlatformServicePowerState"/> values are not the same. </summary>
        public static bool operator !=(AppPlatformServicePowerState left, AppPlatformServicePowerState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppPlatformServicePowerState"/>. </summary>
        public static implicit operator AppPlatformServicePowerState(string value) => new AppPlatformServicePowerState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppPlatformServicePowerState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppPlatformServicePowerState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
