// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Net;
using Azure.Core;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Service network profile payload. </summary>
    public partial class AppPlatformServiceNetworkProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppPlatformServiceNetworkProfile"/>. </summary>
        public AppPlatformServiceNetworkProfile()
        {
            RequiredTraffics = new ChangeTrackingList<AppPlatformServiceRequiredTraffic>();
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatformServiceNetworkProfile"/>. </summary>
        /// <param name="serviceRuntimeSubnetId"> Fully qualified resource Id of the subnet to host Azure Spring Apps Service Runtime. </param>
        /// <param name="appSubnetId"> Fully qualified resource Id of the subnet to host customer apps in Azure Spring Apps. </param>
        /// <param name="serviceCidr"> Azure Spring Apps service reserved CIDR. </param>
        /// <param name="serviceRuntimeNetworkResourceGroup"> Name of the resource group containing network resources of Azure Spring Apps Service Runtime. </param>
        /// <param name="appNetworkResourceGroup"> Name of the resource group containing network resources for customer apps in Azure Spring Apps. </param>
        /// <param name="outboundIPs"> Desired outbound IP resources for Azure Spring Apps resource. </param>
        /// <param name="requiredTraffics"> Required inbound or outbound traffics for Azure Spring Apps resource. </param>
        /// <param name="ingressConfig"> Ingress configuration payload for Azure Spring Apps resource. </param>
        /// <param name="outboundType"> The egress traffic type of Azure Spring Apps VNet instances. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppPlatformServiceNetworkProfile(ResourceIdentifier serviceRuntimeSubnetId, ResourceIdentifier appSubnetId, string serviceCidr, string serviceRuntimeNetworkResourceGroup, string appNetworkResourceGroup, NetworkProfileOutboundIPs outboundIPs, IReadOnlyList<AppPlatformServiceRequiredTraffic> requiredTraffics, IngressConfig ingressConfig, string outboundType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ServiceRuntimeSubnetId = serviceRuntimeSubnetId;
            AppSubnetId = appSubnetId;
            ServiceCidr = serviceCidr;
            ServiceRuntimeNetworkResourceGroup = serviceRuntimeNetworkResourceGroup;
            AppNetworkResourceGroup = appNetworkResourceGroup;
            OutboundIPs = outboundIPs;
            RequiredTraffics = requiredTraffics;
            IngressConfig = ingressConfig;
            OutboundType = outboundType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Fully qualified resource Id of the subnet to host Azure Spring Apps Service Runtime. </summary>
        public ResourceIdentifier ServiceRuntimeSubnetId { get; set; }
        /// <summary> Fully qualified resource Id of the subnet to host customer apps in Azure Spring Apps. </summary>
        public ResourceIdentifier AppSubnetId { get; set; }
        /// <summary> Azure Spring Apps service reserved CIDR. </summary>
        public string ServiceCidr { get; set; }
        /// <summary> Name of the resource group containing network resources of Azure Spring Apps Service Runtime. </summary>
        public string ServiceRuntimeNetworkResourceGroup { get; set; }
        /// <summary> Name of the resource group containing network resources for customer apps in Azure Spring Apps. </summary>
        public string AppNetworkResourceGroup { get; set; }
        /// <summary> Desired outbound IP resources for Azure Spring Apps resource. </summary>
        internal NetworkProfileOutboundIPs OutboundIPs { get; }
        /// <summary> A list of public IP addresses. </summary>
        public IReadOnlyList<IPAddress> OutboundPublicIPs
        {
            get => OutboundIPs?.PublicIPs;
        }

        /// <summary> Required inbound or outbound traffics for Azure Spring Apps resource. </summary>
        public IReadOnlyList<AppPlatformServiceRequiredTraffic> RequiredTraffics { get; }
        /// <summary> Ingress configuration payload for Azure Spring Apps resource. </summary>
        internal IngressConfig IngressConfig { get; set; }
        /// <summary> Ingress read time out in seconds. </summary>
        public int? IngressConfigReadTimeoutInSeconds
        {
            get => IngressConfig is null ? default : IngressConfig.ReadTimeoutInSeconds;
            set
            {
                if (IngressConfig is null)
                    IngressConfig = new IngressConfig();
                IngressConfig.ReadTimeoutInSeconds = value;
            }
        }

        /// <summary> The egress traffic type of Azure Spring Apps VNet instances. </summary>
        public string OutboundType { get; set; }
    }
}
