// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> State of the Monitoring Setting. </summary>
    public readonly partial struct AppPlatformMonitoringSettingState : IEquatable<AppPlatformMonitoringSettingState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppPlatformMonitoringSettingState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppPlatformMonitoringSettingState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotAvailableValue = "NotAvailable";
        private const string FailedValue = "Failed";
        private const string SucceededValue = "Succeeded";
        private const string UpdatingValue = "Updating";

        /// <summary> NotAvailable. </summary>
        public static AppPlatformMonitoringSettingState NotAvailable { get; } = new AppPlatformMonitoringSettingState(NotAvailableValue);
        /// <summary> Failed. </summary>
        public static AppPlatformMonitoringSettingState Failed { get; } = new AppPlatformMonitoringSettingState(FailedValue);
        /// <summary> Succeeded. </summary>
        public static AppPlatformMonitoringSettingState Succeeded { get; } = new AppPlatformMonitoringSettingState(SucceededValue);
        /// <summary> Updating. </summary>
        public static AppPlatformMonitoringSettingState Updating { get; } = new AppPlatformMonitoringSettingState(UpdatingValue);
        /// <summary> Determines if two <see cref="AppPlatformMonitoringSettingState"/> values are the same. </summary>
        public static bool operator ==(AppPlatformMonitoringSettingState left, AppPlatformMonitoringSettingState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppPlatformMonitoringSettingState"/> values are not the same. </summary>
        public static bool operator !=(AppPlatformMonitoringSettingState left, AppPlatformMonitoringSettingState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppPlatformMonitoringSettingState"/>. </summary>
        public static implicit operator AppPlatformMonitoringSettingState(string value) => new AppPlatformMonitoringSettingState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppPlatformMonitoringSettingState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppPlatformMonitoringSettingState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
