// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Monitoring Setting properties payload. </summary>
    public partial class AppPlatformMonitoringSettingProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppPlatformMonitoringSettingProperties"/>. </summary>
        public AppPlatformMonitoringSettingProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatformMonitoringSettingProperties"/>. </summary>
        /// <param name="provisioningState"> State of the Monitoring Setting. </param>
        /// <param name="error"> Error when apply Monitoring Setting changes. </param>
        /// <param name="isTraceEnabled"> Indicates whether enable the trace functionality, which will be deprecated since api version 2020-11-01-preview. Please leverage appInsightsInstrumentationKey to indicate if monitoringSettings enabled or not. </param>
        /// <param name="appInsightsInstrumentationKey"> Target application insight instrumentation key, null or whitespace include empty will disable monitoringSettings. </param>
        /// <param name="appInsightsSamplingRate"> Indicates the sampling rate of application insight agent, should be in range [0.0, 100.0]. </param>
        /// <param name="appInsightsAgentVersions"> Indicates the versions of application insight agent. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppPlatformMonitoringSettingProperties(AppPlatformMonitoringSettingState? provisioningState, AppPlatformErrorInfo error, bool? isTraceEnabled, string appInsightsInstrumentationKey, double? appInsightsSamplingRate, ApplicationInsightsAgentVersions appInsightsAgentVersions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            Error = error;
            IsTraceEnabled = isTraceEnabled;
            AppInsightsInstrumentationKey = appInsightsInstrumentationKey;
            AppInsightsSamplingRate = appInsightsSamplingRate;
            AppInsightsAgentVersions = appInsightsAgentVersions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> State of the Monitoring Setting. </summary>
        public AppPlatformMonitoringSettingState? ProvisioningState { get; }
        /// <summary> Error when apply Monitoring Setting changes. </summary>
        public AppPlatformErrorInfo Error { get; set; }
        /// <summary> Indicates whether enable the trace functionality, which will be deprecated since api version 2020-11-01-preview. Please leverage appInsightsInstrumentationKey to indicate if monitoringSettings enabled or not. </summary>
        public bool? IsTraceEnabled { get; set; }
        /// <summary> Target application insight instrumentation key, null or whitespace include empty will disable monitoringSettings. </summary>
        public string AppInsightsInstrumentationKey { get; set; }
        /// <summary> Indicates the sampling rate of application insight agent, should be in range [0.0, 100.0]. </summary>
        public double? AppInsightsSamplingRate { get; set; }
        /// <summary> Indicates the versions of application insight agent. </summary>
        internal ApplicationInsightsAgentVersions AppInsightsAgentVersions { get; set; }
        /// <summary> Indicates the version of application insight java agent. </summary>
        public string AppInsightsJavaAgentVersion
        {
            get => AppInsightsAgentVersions is null ? default : AppInsightsAgentVersions.AppInsightsJavaAgentVersion;
        }
    }
}
