// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppPlatform.Models
{
    public partial class AppPlatformMonitoringSettingProperties : IUtf8JsonSerializable, IJsonModel<AppPlatformMonitoringSettingProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AppPlatformMonitoringSettingProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AppPlatformMonitoringSettingProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppPlatformMonitoringSettingProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AppPlatformMonitoringSettingProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (Optional.IsDefined(Error))
            {
                writer.WritePropertyName("error"u8);
                writer.WriteObjectValue(Error, options);
            }
            if (Optional.IsDefined(IsTraceEnabled))
            {
                writer.WritePropertyName("traceEnabled"u8);
                writer.WriteBooleanValue(IsTraceEnabled.Value);
            }
            if (Optional.IsDefined(AppInsightsInstrumentationKey))
            {
                writer.WritePropertyName("appInsightsInstrumentationKey"u8);
                writer.WriteStringValue(AppInsightsInstrumentationKey);
            }
            if (Optional.IsDefined(AppInsightsSamplingRate))
            {
                writer.WritePropertyName("appInsightsSamplingRate"u8);
                writer.WriteNumberValue(AppInsightsSamplingRate.Value);
            }
            if (Optional.IsDefined(AppInsightsAgentVersions))
            {
                writer.WritePropertyName("appInsightsAgentVersions"u8);
                writer.WriteObjectValue(AppInsightsAgentVersions, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AppPlatformMonitoringSettingProperties IJsonModel<AppPlatformMonitoringSettingProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppPlatformMonitoringSettingProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AppPlatformMonitoringSettingProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAppPlatformMonitoringSettingProperties(document.RootElement, options);
        }

        internal static AppPlatformMonitoringSettingProperties DeserializeAppPlatformMonitoringSettingProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            AppPlatformMonitoringSettingState? provisioningState = default;
            AppPlatformErrorInfo error = default;
            bool? traceEnabled = default;
            string appInsightsInstrumentationKey = default;
            double? appInsightsSamplingRate = default;
            ApplicationInsightsAgentVersions appInsightsAgentVersions = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("provisioningState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisioningState = new AppPlatformMonitoringSettingState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("error"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    error = AppPlatformErrorInfo.DeserializeAppPlatformErrorInfo(property.Value, options);
                    continue;
                }
                if (property.NameEquals("traceEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    traceEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("appInsightsInstrumentationKey"u8))
                {
                    appInsightsInstrumentationKey = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("appInsightsSamplingRate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    appInsightsSamplingRate = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("appInsightsAgentVersions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    appInsightsAgentVersions = ApplicationInsightsAgentVersions.DeserializeApplicationInsightsAgentVersions(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AppPlatformMonitoringSettingProperties(
                provisioningState,
                error,
                traceEnabled,
                appInsightsInstrumentationKey,
                appInsightsSamplingRate,
                appInsightsAgentVersions,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AppPlatformMonitoringSettingProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppPlatformMonitoringSettingProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AppPlatformMonitoringSettingProperties)} does not support writing '{options.Format}' format.");
            }
        }

        AppPlatformMonitoringSettingProperties IPersistableModel<AppPlatformMonitoringSettingProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppPlatformMonitoringSettingProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAppPlatformMonitoringSettingProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AppPlatformMonitoringSettingProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AppPlatformMonitoringSettingProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
