// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Cross-Origin Resource Sharing property. </summary>
    public partial class AppPlatformGatewayCorsProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppPlatformGatewayCorsProperties"/>. </summary>
        public AppPlatformGatewayCorsProperties()
        {
            AllowedOrigins = new ChangeTrackingList<string>();
            AllowedMethods = new ChangeTrackingList<string>();
            AllowedHeaders = new ChangeTrackingList<string>();
            ExposedHeaders = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatformGatewayCorsProperties"/>. </summary>
        /// <param name="allowedOrigins"> Allowed origins to make cross-site requests. The special value `*` allows all domains. </param>
        /// <param name="allowedMethods"> Allowed HTTP methods on cross-site requests. The special value `*` allows all methods. If not set, `GET` and `HEAD` are allowed by default. </param>
        /// <param name="allowedHeaders"> Allowed headers in cross-site requests. The special value `*` allows actual requests to send any header. </param>
        /// <param name="maxAge"> How long, in seconds, the response from a pre-flight request can be cached by clients. </param>
        /// <param name="areCredentialsAllowed"> Whether user credentials are supported on cross-site requests. Valid values: `true`, `false`. </param>
        /// <param name="exposedHeaders"> HTTP response headers to expose for cross-site requests. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppPlatformGatewayCorsProperties(IList<string> allowedOrigins, IList<string> allowedMethods, IList<string> allowedHeaders, int? maxAge, bool? areCredentialsAllowed, IList<string> exposedHeaders, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AllowedOrigins = allowedOrigins;
            AllowedMethods = allowedMethods;
            AllowedHeaders = allowedHeaders;
            MaxAge = maxAge;
            AreCredentialsAllowed = areCredentialsAllowed;
            ExposedHeaders = exposedHeaders;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Allowed origins to make cross-site requests. The special value `*` allows all domains. </summary>
        public IList<string> AllowedOrigins { get; }
        /// <summary> Allowed HTTP methods on cross-site requests. The special value `*` allows all methods. If not set, `GET` and `HEAD` are allowed by default. </summary>
        public IList<string> AllowedMethods { get; }
        /// <summary> Allowed headers in cross-site requests. The special value `*` allows actual requests to send any header. </summary>
        public IList<string> AllowedHeaders { get; }
        /// <summary> How long, in seconds, the response from a pre-flight request can be cached by clients. </summary>
        public int? MaxAge { get; set; }
        /// <summary> Whether user credentials are supported on cross-site requests. Valid values: `true`, `false`. </summary>
        public bool? AreCredentialsAllowed { get; set; }
        /// <summary> HTTP response headers to expose for cross-site requests. </summary>
        public IList<string> ExposedHeaders { get; }
    }
}
