// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Status of the Deployment. </summary>
    public readonly partial struct AppPlatformDeploymentStatus : IEquatable<AppPlatformDeploymentStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppPlatformDeploymentStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppPlatformDeploymentStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StoppedValue = "Stopped";
        private const string RunningValue = "Running";

        /// <summary> Stopped. </summary>
        public static AppPlatformDeploymentStatus Stopped { get; } = new AppPlatformDeploymentStatus(StoppedValue);
        /// <summary> Running. </summary>
        public static AppPlatformDeploymentStatus Running { get; } = new AppPlatformDeploymentStatus(RunningValue);
        /// <summary> Determines if two <see cref="AppPlatformDeploymentStatus"/> values are the same. </summary>
        public static bool operator ==(AppPlatformDeploymentStatus left, AppPlatformDeploymentStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppPlatformDeploymentStatus"/> values are not the same. </summary>
        public static bool operator !=(AppPlatformDeploymentStatus left, AppPlatformDeploymentStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppPlatformDeploymentStatus"/>. </summary>
        public static implicit operator AppPlatformDeploymentStatus(string value) => new AppPlatformDeploymentStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppPlatformDeploymentStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppPlatformDeploymentStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
