// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Provisioning state of the Deployment. </summary>
    public readonly partial struct AppPlatformDeploymentProvisioningState : IEquatable<AppPlatformDeploymentProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppPlatformDeploymentProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppPlatformDeploymentProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";

        /// <summary> Creating. </summary>
        public static AppPlatformDeploymentProvisioningState Creating { get; } = new AppPlatformDeploymentProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static AppPlatformDeploymentProvisioningState Updating { get; } = new AppPlatformDeploymentProvisioningState(UpdatingValue);
        /// <summary> Succeeded. </summary>
        public static AppPlatformDeploymentProvisioningState Succeeded { get; } = new AppPlatformDeploymentProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static AppPlatformDeploymentProvisioningState Failed { get; } = new AppPlatformDeploymentProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="AppPlatformDeploymentProvisioningState"/> values are the same. </summary>
        public static bool operator ==(AppPlatformDeploymentProvisioningState left, AppPlatformDeploymentProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppPlatformDeploymentProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(AppPlatformDeploymentProvisioningState left, AppPlatformDeploymentProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppPlatformDeploymentProvisioningState"/>. </summary>
        public static implicit operator AppPlatformDeploymentProvisioningState(string value) => new AppPlatformDeploymentProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppPlatformDeploymentProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppPlatformDeploymentProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
