// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Deployment instance payload. </summary>
    public partial class AppPlatformDeploymentInstance
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppPlatformDeploymentInstance"/>. </summary>
        internal AppPlatformDeploymentInstance()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatformDeploymentInstance"/>. </summary>
        /// <param name="name"> Name of the deployment instance. </param>
        /// <param name="status"> Status of the deployment instance. </param>
        /// <param name="reason"> Failed reason of the deployment instance. </param>
        /// <param name="discoveryStatus"> Discovery status of the deployment instance. </param>
        /// <param name="startedOn"> Start time of the deployment instance. </param>
        /// <param name="zone"> Availability zone information of the deployment instance. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppPlatformDeploymentInstance(string name, string status, string reason, string discoveryStatus, DateTimeOffset? startedOn, string zone, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Status = status;
            Reason = reason;
            DiscoveryStatus = discoveryStatus;
            StartedOn = startedOn;
            Zone = zone;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the deployment instance. </summary>
        public string Name { get; }
        /// <summary> Status of the deployment instance. </summary>
        public string Status { get; }
        /// <summary> Failed reason of the deployment instance. </summary>
        public string Reason { get; }
        /// <summary> Discovery status of the deployment instance. </summary>
        public string DiscoveryStatus { get; }
        /// <summary> Start time of the deployment instance. </summary>
        public DateTimeOffset? StartedOn { get; }
        /// <summary> Availability zone information of the deployment instance. </summary>
        public string Zone { get; }
    }
}
