// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Custom container user source info. </summary>
    public partial class AppPlatformCustomContainerUserSourceInfo : AppPlatformUserSourceInfo
    {
        /// <summary> Initializes a new instance of <see cref="AppPlatformCustomContainerUserSourceInfo"/>. </summary>
        public AppPlatformCustomContainerUserSourceInfo()
        {
            UserSourceInfoType = "Container";
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatformCustomContainerUserSourceInfo"/>. </summary>
        /// <param name="userSourceInfoType"> Type of the source uploaded. </param>
        /// <param name="version"> Version of the source. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="customContainer"> Custom container payload. </param>
        internal AppPlatformCustomContainerUserSourceInfo(string userSourceInfoType, string version, IDictionary<string, BinaryData> serializedAdditionalRawData, AppPlatformCustomContainer customContainer) : base(userSourceInfoType, version, serializedAdditionalRawData)
        {
            CustomContainer = customContainer;
            UserSourceInfoType = userSourceInfoType ?? "Container";
        }

        /// <summary> Custom container payload. </summary>
        public AppPlatformCustomContainer CustomContainer { get; set; }
    }
}
