// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> The settings of Application Configuration Service. </summary>
    public partial class AppPlatformConfigurationServiceSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppPlatformConfigurationServiceSettings"/>. </summary>
        public AppPlatformConfigurationServiceSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatformConfigurationServiceSettings"/>. </summary>
        /// <param name="gitProperty"> Property of git environment. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppPlatformConfigurationServiceSettings(ConfigurationServiceGitProperty gitProperty, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            GitProperty = gitProperty;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Property of git environment. </summary>
        internal ConfigurationServiceGitProperty GitProperty { get; set; }
        /// <summary> Repositories of Application Configuration Service git property. </summary>
        public IList<AppPlatformConfigurationServiceGitRepository> ConfigurationServiceGitRepositories
        {
            get
            {
                if (GitProperty is null)
                    GitProperty = new ConfigurationServiceGitProperty();
                return GitProperty.ConfigurationServiceGitRepositories;
            }
        }
    }
}
