// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Resource request payload of Application Configuration Service. </summary>
    public partial class AppPlatformConfigurationServiceRequirements
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppPlatformConfigurationServiceRequirements"/>. </summary>
        internal AppPlatformConfigurationServiceRequirements()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatformConfigurationServiceRequirements"/>. </summary>
        /// <param name="cpu"> Cpu allocated to each Application Configuration Service instance. </param>
        /// <param name="memory"> Memory allocated to each Application Configuration Service instance. </param>
        /// <param name="instanceCount"> Instance count of the Application Configuration Service. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppPlatformConfigurationServiceRequirements(string cpu, string memory, int? instanceCount, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Cpu = cpu;
            Memory = memory;
            InstanceCount = instanceCount;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Cpu allocated to each Application Configuration Service instance. </summary>
        public string Cpu { get; }
        /// <summary> Memory allocated to each Application Configuration Service instance. </summary>
        public string Memory { get; }
        /// <summary> Instance count of the Application Configuration Service. </summary>
        public int? InstanceCount { get; }
    }
}
