// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> State of the config server. </summary>
    public readonly partial struct AppPlatformConfigServerState : IEquatable<AppPlatformConfigServerState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppPlatformConfigServerState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppPlatformConfigServerState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotAvailableValue = "NotAvailable";
        private const string DeletedValue = "Deleted";
        private const string FailedValue = "Failed";
        private const string SucceededValue = "Succeeded";
        private const string UpdatingValue = "Updating";

        /// <summary> NotAvailable. </summary>
        public static AppPlatformConfigServerState NotAvailable { get; } = new AppPlatformConfigServerState(NotAvailableValue);
        /// <summary> Deleted. </summary>
        public static AppPlatformConfigServerState Deleted { get; } = new AppPlatformConfigServerState(DeletedValue);
        /// <summary> Failed. </summary>
        public static AppPlatformConfigServerState Failed { get; } = new AppPlatformConfigServerState(FailedValue);
        /// <summary> Succeeded. </summary>
        public static AppPlatformConfigServerState Succeeded { get; } = new AppPlatformConfigServerState(SucceededValue);
        /// <summary> Updating. </summary>
        public static AppPlatformConfigServerState Updating { get; } = new AppPlatformConfigServerState(UpdatingValue);
        /// <summary> Determines if two <see cref="AppPlatformConfigServerState"/> values are the same. </summary>
        public static bool operator ==(AppPlatformConfigServerState left, AppPlatformConfigServerState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppPlatformConfigServerState"/> values are not the same. </summary>
        public static bool operator !=(AppPlatformConfigServerState left, AppPlatformConfigServerState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppPlatformConfigServerState"/>. </summary>
        public static implicit operator AppPlatformConfigServerState(string value) => new AppPlatformConfigServerState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppPlatformConfigServerState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppPlatformConfigServerState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
