// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Config server git properties payload. </summary>
    public partial class AppPlatformConfigServerProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppPlatformConfigServerProperties"/>. </summary>
        public AppPlatformConfigServerProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatformConfigServerProperties"/>. </summary>
        /// <param name="provisioningState"> State of the config server. </param>
        /// <param name="error"> Error when apply config server settings. </param>
        /// <param name="configServer"> Settings of config server. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppPlatformConfigServerProperties(AppPlatformConfigServerState? provisioningState, AppPlatformErrorInfo error, ConfigServerSettings configServer, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            Error = error;
            ConfigServer = configServer;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> State of the config server. </summary>
        public AppPlatformConfigServerState? ProvisioningState { get; }
        /// <summary> Error when apply config server settings. </summary>
        public AppPlatformErrorInfo Error { get; set; }
        /// <summary> Settings of config server. </summary>
        internal ConfigServerSettings ConfigServer { get; set; }
        /// <summary> Property of git environment. </summary>
        public AppPlatformConfigServerGitProperty ConfigServerGitProperty
        {
            get => ConfigServer is null ? default : ConfigServer.GitProperty;
            set
            {
                if (ConfigServer is null)
                    ConfigServer = new ConfigServerSettings();
                ConfigServer.GitProperty = value;
            }
        }
    }
}
