// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Builder provision status. </summary>
    public readonly partial struct AppPlatformBuilderProvisioningState : IEquatable<AppPlatformBuilderProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppPlatformBuilderProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppPlatformBuilderProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string DeletingValue = "Deleting";

        /// <summary> Creating. </summary>
        public static AppPlatformBuilderProvisioningState Creating { get; } = new AppPlatformBuilderProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static AppPlatformBuilderProvisioningState Updating { get; } = new AppPlatformBuilderProvisioningState(UpdatingValue);
        /// <summary> Succeeded. </summary>
        public static AppPlatformBuilderProvisioningState Succeeded { get; } = new AppPlatformBuilderProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static AppPlatformBuilderProvisioningState Failed { get; } = new AppPlatformBuilderProvisioningState(FailedValue);
        /// <summary> Deleting. </summary>
        public static AppPlatformBuilderProvisioningState Deleting { get; } = new AppPlatformBuilderProvisioningState(DeletingValue);
        /// <summary> Determines if two <see cref="AppPlatformBuilderProvisioningState"/> values are the same. </summary>
        public static bool operator ==(AppPlatformBuilderProvisioningState left, AppPlatformBuilderProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppPlatformBuilderProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(AppPlatformBuilderProvisioningState left, AppPlatformBuilderProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppPlatformBuilderProvisioningState"/>. </summary>
        public static implicit operator AppPlatformBuilderProvisioningState(string value) => new AppPlatformBuilderProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppPlatformBuilderProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppPlatformBuilderProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
