// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> KPack Builder properties payload. </summary>
    public partial class AppPlatformBuilderProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppPlatformBuilderProperties"/>. </summary>
        public AppPlatformBuilderProperties()
        {
            BuildpackGroups = new ChangeTrackingList<BuildpacksGroupProperties>();
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatformBuilderProperties"/>. </summary>
        /// <param name="provisioningState"> Builder provision status. </param>
        /// <param name="stack"> Builder cluster stack property. </param>
        /// <param name="buildpackGroups"> Builder buildpack groups. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppPlatformBuilderProperties(AppPlatformBuilderProvisioningState? provisioningState, AppPlatformClusterStackProperties stack, IList<BuildpacksGroupProperties> buildpackGroups, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            Stack = stack;
            BuildpackGroups = buildpackGroups;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Builder provision status. </summary>
        public AppPlatformBuilderProvisioningState? ProvisioningState { get; }
        /// <summary> Builder cluster stack property. </summary>
        public AppPlatformClusterStackProperties Stack { get; set; }
        /// <summary> Builder buildpack groups. </summary>
        public IList<BuildpacksGroupProperties> BuildpackGroups { get; }
    }
}
