// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Provisioning state of the KPack build result. </summary>
    public readonly partial struct AppPlatformBuildServiceProvisioningState : IEquatable<AppPlatformBuildServiceProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppPlatformBuildServiceProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppPlatformBuildServiceProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string DeletingValue = "Deleting";

        /// <summary> Creating. </summary>
        public static AppPlatformBuildServiceProvisioningState Creating { get; } = new AppPlatformBuildServiceProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static AppPlatformBuildServiceProvisioningState Updating { get; } = new AppPlatformBuildServiceProvisioningState(UpdatingValue);
        /// <summary> Succeeded. </summary>
        public static AppPlatformBuildServiceProvisioningState Succeeded { get; } = new AppPlatformBuildServiceProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static AppPlatformBuildServiceProvisioningState Failed { get; } = new AppPlatformBuildServiceProvisioningState(FailedValue);
        /// <summary> Deleting. </summary>
        public static AppPlatformBuildServiceProvisioningState Deleting { get; } = new AppPlatformBuildServiceProvisioningState(DeletingValue);
        /// <summary> Determines if two <see cref="AppPlatformBuildServiceProvisioningState"/> values are the same. </summary>
        public static bool operator ==(AppPlatformBuildServiceProvisioningState left, AppPlatformBuildServiceProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppPlatformBuildServiceProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(AppPlatformBuildServiceProvisioningState left, AppPlatformBuildServiceProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppPlatformBuildServiceProvisioningState"/>. </summary>
        public static implicit operator AppPlatformBuildServiceProvisioningState(string value) => new AppPlatformBuildServiceProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppPlatformBuildServiceProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppPlatformBuildServiceProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
