// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Build service resource properties payload. </summary>
    public partial class AppPlatformBuildServiceProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppPlatformBuildServiceProperties"/>. </summary>
        public AppPlatformBuildServiceProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatformBuildServiceProperties"/>. </summary>
        /// <param name="kPackVersion"> The installed KPack version in this build service. </param>
        /// <param name="provisioningState"> Provisioning state of the KPack build result. </param>
        /// <param name="resourceRequests"> The runtime resource configuration of this build service. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppPlatformBuildServiceProperties(string kPackVersion, AppPlatformBuildServiceProvisioningState? provisioningState, AppPlatformBuildServiceResourceRequirements resourceRequests, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KPackVersion = kPackVersion;
            ProvisioningState = provisioningState;
            ResourceRequests = resourceRequests;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The installed KPack version in this build service. </summary>
        public string KPackVersion { get; set; }
        /// <summary> Provisioning state of the KPack build result. </summary>
        public AppPlatformBuildServiceProvisioningState? ProvisioningState { get; }
        /// <summary> The runtime resource configuration of this build service. </summary>
        public AppPlatformBuildServiceResourceRequirements ResourceRequests { get; set; }
    }
}
