// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Provisioning state of the KPack build result. </summary>
    public readonly partial struct AppPlatformBuildResultProvisioningState : IEquatable<AppPlatformBuildResultProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppPlatformBuildResultProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppPlatformBuildResultProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string QueuingValue = "Queuing";
        private const string BuildingValue = "Building";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string DeletingValue = "Deleting";

        /// <summary> Queuing. </summary>
        public static AppPlatformBuildResultProvisioningState Queuing { get; } = new AppPlatformBuildResultProvisioningState(QueuingValue);
        /// <summary> Building. </summary>
        public static AppPlatformBuildResultProvisioningState Building { get; } = new AppPlatformBuildResultProvisioningState(BuildingValue);
        /// <summary> Succeeded. </summary>
        public static AppPlatformBuildResultProvisioningState Succeeded { get; } = new AppPlatformBuildResultProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static AppPlatformBuildResultProvisioningState Failed { get; } = new AppPlatformBuildResultProvisioningState(FailedValue);
        /// <summary> Deleting. </summary>
        public static AppPlatformBuildResultProvisioningState Deleting { get; } = new AppPlatformBuildResultProvisioningState(DeletingValue);
        /// <summary> Determines if two <see cref="AppPlatformBuildResultProvisioningState"/> values are the same. </summary>
        public static bool operator ==(AppPlatformBuildResultProvisioningState left, AppPlatformBuildResultProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppPlatformBuildResultProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(AppPlatformBuildResultProvisioningState left, AppPlatformBuildResultProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppPlatformBuildResultProvisioningState"/>. </summary>
        public static implicit operator AppPlatformBuildResultProvisioningState(string value) => new AppPlatformBuildResultProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppPlatformBuildResultProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppPlatformBuildResultProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
