// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Build resource properties payload. </summary>
    public partial class AppPlatformBuildProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppPlatformBuildProperties"/>. </summary>
        public AppPlatformBuildProperties()
        {
            Env = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatformBuildProperties"/>. </summary>
        /// <param name="relativePath"> The relative path of source code. </param>
        /// <param name="builder"> The resource id of builder to build the source code. </param>
        /// <param name="agentPool"> The resource id of agent pool. </param>
        /// <param name="provisioningState"> Provisioning state of the KPack build result. </param>
        /// <param name="env"> The environment variables for this build. </param>
        /// <param name="triggeredBuildResult"> The build result triggered by this build. </param>
        /// <param name="resourceRequests"> The customized build resource for this build. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppPlatformBuildProperties(string relativePath, string builder, string agentPool, AppPlatformBuildProvisioningState? provisioningState, IDictionary<string, string> env, SubResource triggeredBuildResult, AppPlatformBuildResourceRequirements resourceRequests, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RelativePath = relativePath;
            Builder = builder;
            AgentPool = agentPool;
            ProvisioningState = provisioningState;
            Env = env;
            TriggeredBuildResult = triggeredBuildResult;
            ResourceRequests = resourceRequests;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The relative path of source code. </summary>
        public string RelativePath { get; set; }
        /// <summary> The resource id of builder to build the source code. </summary>
        public string Builder { get; set; }
        /// <summary> The resource id of agent pool. </summary>
        public string AgentPool { get; set; }
        /// <summary> Provisioning state of the KPack build result. </summary>
        public AppPlatformBuildProvisioningState? ProvisioningState { get; }
        /// <summary> The environment variables for this build. </summary>
        public IDictionary<string, string> Env { get; }
        /// <summary> The build result triggered by this build. </summary>
        internal SubResource TriggeredBuildResult { get; }
        /// <summary> Gets Id. </summary>
        public ResourceIdentifier TriggeredBuildResultId
        {
            get => TriggeredBuildResult?.Id;
        }

        /// <summary> The customized build resource for this build. </summary>
        public AppPlatformBuildResourceRequirements ResourceRequests { get; set; }
    }
}
