// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> API portal properties payload. </summary>
    public partial class AppPlatformApiPortalProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppPlatformApiPortalProperties"/>. </summary>
        public AppPlatformApiPortalProperties()
        {
            GatewayIds = new ChangeTrackingList<ResourceIdentifier>();
            SourceUris = new ChangeTrackingList<Uri>();
            Instances = new ChangeTrackingList<AppPlatformApiPortalInstance>();
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatformApiPortalProperties"/>. </summary>
        /// <param name="provisioningState"> State of the API portal. </param>
        /// <param name="isPublic"> Indicates whether the API portal exposes endpoint. </param>
        /// <param name="uri"> URL of the API portal, exposed when 'public' is true. </param>
        /// <param name="isHttpsOnly"> Indicate if only https is allowed. </param>
        /// <param name="gatewayIds"> The array of resource Ids of gateway to integrate with API portal. </param>
        /// <param name="sourceUris"> Collection of OpenAPI source URL locations. </param>
        /// <param name="ssoProperties"> Single sign-on related configuration. </param>
        /// <param name="resourceRequests"> The requested resource quantity for required CPU and Memory. </param>
        /// <param name="instances"> Collection of instances belong to API portal. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppPlatformApiPortalProperties(AppPlatformApiPortalProvisioningState? provisioningState, bool? isPublic, Uri uri, bool? isHttpsOnly, IList<ResourceIdentifier> gatewayIds, IList<Uri> sourceUris, AppPlatformSsoProperties ssoProperties, AppPlatformApiPortalResourceRequirements resourceRequests, IReadOnlyList<AppPlatformApiPortalInstance> instances, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            IsPublic = isPublic;
            Uri = uri;
            IsHttpsOnly = isHttpsOnly;
            GatewayIds = gatewayIds;
            SourceUris = sourceUris;
            SsoProperties = ssoProperties;
            ResourceRequests = resourceRequests;
            Instances = instances;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> State of the API portal. </summary>
        public AppPlatformApiPortalProvisioningState? ProvisioningState { get; }
        /// <summary> Indicates whether the API portal exposes endpoint. </summary>
        public bool? IsPublic { get; set; }
        /// <summary> URL of the API portal, exposed when 'public' is true. </summary>
        public Uri Uri { get; }
        /// <summary> Indicate if only https is allowed. </summary>
        public bool? IsHttpsOnly { get; set; }
        /// <summary> The array of resource Ids of gateway to integrate with API portal. </summary>
        public IList<ResourceIdentifier> GatewayIds { get; }
        /// <summary> Collection of OpenAPI source URL locations. </summary>
        public IList<Uri> SourceUris { get; }
        /// <summary> Single sign-on related configuration. </summary>
        public AppPlatformSsoProperties SsoProperties { get; set; }
        /// <summary> The requested resource quantity for required CPU and Memory. </summary>
        public AppPlatformApiPortalResourceRequirements ResourceRequests { get; }
        /// <summary> Collection of instances belong to API portal. </summary>
        public IReadOnlyList<AppPlatformApiPortalInstance> Instances { get; }
    }
}
