// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Persistent disk payload. </summary>
    public partial class AppPersistentDisk
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppPersistentDisk"/>. </summary>
        public AppPersistentDisk()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AppPersistentDisk"/>. </summary>
        /// <param name="sizeInGB"> Size of the persistent disk in GB. </param>
        /// <param name="usedInGB"> Size of the used persistent disk in GB. </param>
        /// <param name="mountPath"> Mount path of the persistent disk. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppPersistentDisk(int? sizeInGB, int? usedInGB, string mountPath, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SizeInGB = sizeInGB;
            UsedInGB = usedInGB;
            MountPath = mountPath;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Size of the persistent disk in GB. </summary>
        public int? SizeInGB { get; set; }
        /// <summary> Size of the used persistent disk in GB. </summary>
        public int? UsedInGB { get; }
        /// <summary> Mount path of the persistent disk. </summary>
        public string MountPath { get; set; }
    }
}
