// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Probe describes a health check to be performed against an App Instance to determine whether it is alive or ready to receive traffic. </summary>
    public partial class AppInstanceProbe
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppInstanceProbe"/>. </summary>
        /// <param name="isProbeDisabled"> Indicate whether the probe is disabled. </param>
        public AppInstanceProbe(bool isProbeDisabled)
        {
            IsProbeDisabled = isProbeDisabled;
        }

        /// <summary> Initializes a new instance of <see cref="AppInstanceProbe"/>. </summary>
        /// <param name="probeAction">
        /// The action of the probe.
        /// Please note <see cref="AppInstanceProbeAction"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AppInstanceExecAction"/>, <see cref="AppInstanceHttpGetAction"/> and <see cref="AppInstanceTcpSocketAction"/>.
        /// </param>
        /// <param name="isProbeDisabled"> Indicate whether the probe is disabled. </param>
        /// <param name="initialDelayInSeconds"> Number of seconds after the App Instance has started before probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes. </param>
        /// <param name="periodInSeconds"> How often (in seconds) to perform the probe. Minimum value is 1. </param>
        /// <param name="timeoutInSeconds"> Number of seconds after which the probe times out. Minimum value is 1. </param>
        /// <param name="failureThreshold"> Minimum consecutive failures for the probe to be considered failed after having succeeded. Minimum value is 1. </param>
        /// <param name="successThreshold"> Minimum consecutive successes for the probe to be considered successful after having failed. Must be 1 for liveness and startup. Minimum value is 1. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppInstanceProbe(AppInstanceProbeAction probeAction, bool isProbeDisabled, int? initialDelayInSeconds, int? periodInSeconds, int? timeoutInSeconds, int? failureThreshold, int? successThreshold, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProbeAction = probeAction;
            IsProbeDisabled = isProbeDisabled;
            InitialDelayInSeconds = initialDelayInSeconds;
            PeriodInSeconds = periodInSeconds;
            TimeoutInSeconds = timeoutInSeconds;
            FailureThreshold = failureThreshold;
            SuccessThreshold = successThreshold;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AppInstanceProbe"/> for deserialization. </summary>
        internal AppInstanceProbe()
        {
        }

        /// <summary>
        /// The action of the probe.
        /// Please note <see cref="AppInstanceProbeAction"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AppInstanceExecAction"/>, <see cref="AppInstanceHttpGetAction"/> and <see cref="AppInstanceTcpSocketAction"/>.
        /// </summary>
        public AppInstanceProbeAction ProbeAction { get; set; }
        /// <summary> Indicate whether the probe is disabled. </summary>
        public bool IsProbeDisabled { get; set; }
        /// <summary> Number of seconds after the App Instance has started before probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes. </summary>
        public int? InitialDelayInSeconds { get; set; }
        /// <summary> How often (in seconds) to perform the probe. Minimum value is 1. </summary>
        public int? PeriodInSeconds { get; set; }
        /// <summary> Number of seconds after which the probe times out. Minimum value is 1. </summary>
        public int? TimeoutInSeconds { get; set; }
        /// <summary> Minimum consecutive failures for the probe to be considered failed after having succeeded. Minimum value is 1. </summary>
        public int? FailureThreshold { get; set; }
        /// <summary> Minimum consecutive successes for the probe to be considered successful after having failed. Must be 1 for liveness and startup. Minimum value is 1. </summary>
        public int? SuccessThreshold { get; set; }
    }
}
