// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> HTTPGetAction describes an action based on HTTP Get requests. </summary>
    public partial class AppInstanceHttpGetAction : AppInstanceProbeAction
    {
        /// <summary> Initializes a new instance of <see cref="AppInstanceHttpGetAction"/>. </summary>
        public AppInstanceHttpGetAction()
        {
            ProbeActionType = ProbeActionType.HttpGetAction;
        }

        /// <summary> Initializes a new instance of <see cref="AppInstanceHttpGetAction"/>. </summary>
        /// <param name="probeActionType"> The type of the action to take to perform the health check. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="path"> Path to access on the HTTP server. </param>
        /// <param name="scheme">
        /// Scheme to use for connecting to the host. Defaults to HTTP.
        ///
        /// Possible enum values:
        ///  - `"HTTP"` means that the scheme used will be http://
        ///  - `"HTTPS"` means that the scheme used will be https://
        /// </param>
        internal AppInstanceHttpGetAction(ProbeActionType probeActionType, IDictionary<string, BinaryData> serializedAdditionalRawData, string path, AppInstanceHttpSchemeType? scheme) : base(probeActionType, serializedAdditionalRawData)
        {
            Path = path;
            Scheme = scheme;
            ProbeActionType = probeActionType;
        }

        /// <summary> Path to access on the HTTP server. </summary>
        public string Path { get; set; }
        /// <summary>
        /// Scheme to use for connecting to the host. Defaults to HTTP.
        ///
        /// Possible enum values:
        ///  - `"HTTP"` means that the scheme used will be http://
        ///  - `"HTTPS"` means that the scheme used will be https://
        /// </summary>
        public AppInstanceHttpSchemeType? Scheme { get; set; }
    }
}
