// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> App ingress settings payload. </summary>
    public partial class AppIngressSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppIngressSettings"/>. </summary>
        public AppIngressSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AppIngressSettings"/>. </summary>
        /// <param name="readTimeoutInSeconds"> Ingress read time out in seconds. </param>
        /// <param name="sendTimeoutInSeconds"> Ingress send time out in seconds. </param>
        /// <param name="sessionAffinity"> Type of the affinity, set this to Cookie to enable session affinity. </param>
        /// <param name="sessionCookieMaxAge"> Time in seconds until the cookie expires. </param>
        /// <param name="backendProtocol"> How ingress should communicate with this app backend service. </param>
        /// <param name="clientAuth"> Client-Certification Authentication. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppIngressSettings(int? readTimeoutInSeconds, int? sendTimeoutInSeconds, AppSessionAffinity? sessionAffinity, int? sessionCookieMaxAge, AppBackendProtocol? backendProtocol, IngressSettingsClientAuth clientAuth, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ReadTimeoutInSeconds = readTimeoutInSeconds;
            SendTimeoutInSeconds = sendTimeoutInSeconds;
            SessionAffinity = sessionAffinity;
            SessionCookieMaxAge = sessionCookieMaxAge;
            BackendProtocol = backendProtocol;
            ClientAuth = clientAuth;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Ingress read time out in seconds. </summary>
        public int? ReadTimeoutInSeconds { get; set; }
        /// <summary> Ingress send time out in seconds. </summary>
        public int? SendTimeoutInSeconds { get; set; }
        /// <summary> Type of the affinity, set this to Cookie to enable session affinity. </summary>
        public AppSessionAffinity? SessionAffinity { get; set; }
        /// <summary> Time in seconds until the cookie expires. </summary>
        public int? SessionCookieMaxAge { get; set; }
        /// <summary> How ingress should communicate with this app backend service. </summary>
        public AppBackendProtocol? BackendProtocol { get; set; }
        /// <summary> Client-Certification Authentication. </summary>
        internal IngressSettingsClientAuth ClientAuth { get; set; }
        /// <summary> Collection of certificate resource id. </summary>
        public IList<string> ClientAuthCertificates
        {
            get
            {
                if (ClientAuth is null)
                    ClientAuth = new IngressSettingsClientAuth();
                return ClientAuth.Certificates;
            }
        }
    }
}
