// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary>
    /// Custom persistent disk resource payload.
    /// Please note <see cref="AppCustomPersistentDiskProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="AppPlatformAzureFileVolume"/>.
    /// </summary>
    public abstract partial class AppCustomPersistentDiskProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppCustomPersistentDiskProperties"/>. </summary>
        /// <param name="mountPath"> The mount path of the persistent disk. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="mountPath"/> is null. </exception>
        protected AppCustomPersistentDiskProperties(string mountPath)
        {
            Argument.AssertNotNull(mountPath, nameof(mountPath));

            MountPath = mountPath;
            MountOptions = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AppCustomPersistentDiskProperties"/>. </summary>
        /// <param name="underlyingResourceType"> The type of the underlying resource to mount as a persistent disk. </param>
        /// <param name="mountPath"> The mount path of the persistent disk. </param>
        /// <param name="isReadOnly"> Indicates whether the persistent disk is a readOnly one. </param>
        /// <param name="mountOptions"> These are the mount options for a persistent disk. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppCustomPersistentDiskProperties(UnderlyingResourceType underlyingResourceType, string mountPath, bool? isReadOnly, IList<string> mountOptions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UnderlyingResourceType = underlyingResourceType;
            MountPath = mountPath;
            IsReadOnly = isReadOnly;
            MountOptions = mountOptions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AppCustomPersistentDiskProperties"/> for deserialization. </summary>
        internal AppCustomPersistentDiskProperties()
        {
        }

        /// <summary> The type of the underlying resource to mount as a persistent disk. </summary>
        internal UnderlyingResourceType UnderlyingResourceType { get; set; }
        /// <summary> The mount path of the persistent disk. </summary>
        public string MountPath { get; set; }
        /// <summary> Indicates whether the persistent disk is a readOnly one. </summary>
        public bool? IsReadOnly { get; set; }
        /// <summary> These are the mount options for a persistent disk. </summary>
        public IList<string> MountOptions { get; }
    }
}
