// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Custom persistent disk resource payload. </summary>
    public partial class AppCustomPersistentDisk
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppCustomPersistentDisk"/>. </summary>
        /// <param name="storageId"> The resource id of Azure Spring Apps Storage resource. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="storageId"/> is null. </exception>
        public AppCustomPersistentDisk(string storageId)
        {
            Argument.AssertNotNull(storageId, nameof(storageId));

            StorageId = storageId;
        }

        /// <summary> Initializes a new instance of <see cref="AppCustomPersistentDisk"/>. </summary>
        /// <param name="customPersistentDiskProperties">
        /// Properties of the custom persistent disk resource payload.
        /// Please note <see cref="AppCustomPersistentDiskProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AppPlatformAzureFileVolume"/>.
        /// </param>
        /// <param name="storageId"> The resource id of Azure Spring Apps Storage resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppCustomPersistentDisk(AppCustomPersistentDiskProperties customPersistentDiskProperties, string storageId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CustomPersistentDiskProperties = customPersistentDiskProperties;
            StorageId = storageId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AppCustomPersistentDisk"/> for deserialization. </summary>
        internal AppCustomPersistentDisk()
        {
        }

        /// <summary>
        /// Properties of the custom persistent disk resource payload.
        /// Please note <see cref="AppCustomPersistentDiskProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AppPlatformAzureFileVolume"/>.
        /// </summary>
        public AppCustomPersistentDiskProperties CustomPersistentDiskProperties { get; set; }
        /// <summary> The resource id of Azure Spring Apps Storage resource. </summary>
        public string StorageId { get; set; }
    }
}
