// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AppPlatform.Models
{
    public partial class AppCustomPersistentDisk : IUtf8JsonSerializable, IJsonModel<AppCustomPersistentDisk>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AppCustomPersistentDisk>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AppCustomPersistentDisk>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppCustomPersistentDisk>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AppCustomPersistentDisk)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(CustomPersistentDiskProperties))
            {
                writer.WritePropertyName("customPersistentDiskProperties"u8);
                writer.WriteObjectValue(CustomPersistentDiskProperties, options);
            }
            writer.WritePropertyName("storageId"u8);
            writer.WriteStringValue(StorageId);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AppCustomPersistentDisk IJsonModel<AppCustomPersistentDisk>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppCustomPersistentDisk>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AppCustomPersistentDisk)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAppCustomPersistentDisk(document.RootElement, options);
        }

        internal static AppCustomPersistentDisk DeserializeAppCustomPersistentDisk(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            AppCustomPersistentDiskProperties customPersistentDiskProperties = default;
            string storageId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("customPersistentDiskProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    customPersistentDiskProperties = AppCustomPersistentDiskProperties.DeserializeAppCustomPersistentDiskProperties(property.Value, options);
                    continue;
                }
                if (property.NameEquals("storageId"u8))
                {
                    storageId = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AppCustomPersistentDisk(customPersistentDiskProperties, storageId, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AppCustomPersistentDisk>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppCustomPersistentDisk>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AppCustomPersistentDisk)} does not support writing '{options.Format}' format.");
            }
        }

        AppCustomPersistentDisk IPersistableModel<AppCustomPersistentDisk>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AppCustomPersistentDisk>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAppCustomPersistentDisk(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AppCustomPersistentDisk)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AppCustomPersistentDisk>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
