// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.AppPlatform.Models;

namespace Azure.ResourceManager.AppPlatform
{
    internal class ConfigServerSettingsValidateResultOperationSource : IOperationSource<ConfigServerSettingsValidateResult>
    {
        ConfigServerSettingsValidateResult IOperationSource<ConfigServerSettingsValidateResult>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return ConfigServerSettingsValidateResult.DeserializeConfigServerSettingsValidateResult(document.RootElement);
        }

        async ValueTask<ConfigServerSettingsValidateResult> IOperationSource<ConfigServerSettingsValidateResult>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return ConfigServerSettingsValidateResult.DeserializeConfigServerSettingsValidateResult(document.RootElement);
        }
    }
}
