// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppPlatform
{
    internal class AppPlatformServiceRegistryOperationSource : IOperationSource<AppPlatformServiceRegistryResource>
    {
        private readonly ArmClient _client;

        internal AppPlatformServiceRegistryOperationSource(ArmClient client)
        {
            _client = client;
        }

        AppPlatformServiceRegistryResource IOperationSource<AppPlatformServiceRegistryResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AppPlatformServiceRegistryData.DeserializeAppPlatformServiceRegistryData(document.RootElement);
            return new AppPlatformServiceRegistryResource(_client, data);
        }

        async ValueTask<AppPlatformServiceRegistryResource> IOperationSource<AppPlatformServiceRegistryResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AppPlatformServiceRegistryData.DeserializeAppPlatformServiceRegistryData(document.RootElement);
            return new AppPlatformServiceRegistryResource(_client, data);
        }
    }
}
