// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppPlatform
{
    internal class AppPlatformGatewayRouteConfigOperationSource : IOperationSource<AppPlatformGatewayRouteConfigResource>
    {
        private readonly ArmClient _client;

        internal AppPlatformGatewayRouteConfigOperationSource(ArmClient client)
        {
            _client = client;
        }

        AppPlatformGatewayRouteConfigResource IOperationSource<AppPlatformGatewayRouteConfigResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AppPlatformGatewayRouteConfigData.DeserializeAppPlatformGatewayRouteConfigData(document.RootElement);
            return new AppPlatformGatewayRouteConfigResource(_client, data);
        }

        async ValueTask<AppPlatformGatewayRouteConfigResource> IOperationSource<AppPlatformGatewayRouteConfigResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AppPlatformGatewayRouteConfigData.DeserializeAppPlatformGatewayRouteConfigData(document.RootElement);
            return new AppPlatformGatewayRouteConfigResource(_client, data);
        }
    }
}
