// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppPlatform
{
    internal class AppPlatformGatewayOperationSource : IOperationSource<AppPlatformGatewayResource>
    {
        private readonly ArmClient _client;

        internal AppPlatformGatewayOperationSource(ArmClient client)
        {
            _client = client;
        }

        AppPlatformGatewayResource IOperationSource<AppPlatformGatewayResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AppPlatformGatewayData.DeserializeAppPlatformGatewayData(document.RootElement);
            return new AppPlatformGatewayResource(_client, data);
        }

        async ValueTask<AppPlatformGatewayResource> IOperationSource<AppPlatformGatewayResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AppPlatformGatewayData.DeserializeAppPlatformGatewayData(document.RootElement);
            return new AppPlatformGatewayResource(_client, data);
        }
    }
}
