// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppPlatform
{
    internal class AppPlatformDeploymentOperationSource : IOperationSource<AppPlatformDeploymentResource>
    {
        private readonly ArmClient _client;

        internal AppPlatformDeploymentOperationSource(ArmClient client)
        {
            _client = client;
        }

        AppPlatformDeploymentResource IOperationSource<AppPlatformDeploymentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AppPlatformDeploymentData.DeserializeAppPlatformDeploymentData(document.RootElement);
            return new AppPlatformDeploymentResource(_client, data);
        }

        async ValueTask<AppPlatformDeploymentResource> IOperationSource<AppPlatformDeploymentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AppPlatformDeploymentData.DeserializeAppPlatformDeploymentData(document.RootElement);
            return new AppPlatformDeploymentResource(_client, data);
        }
    }
}
