// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppPlatform
{
    internal class AppPlatformCustomDomainOperationSource : IOperationSource<AppPlatformCustomDomainResource>
    {
        private readonly ArmClient _client;

        internal AppPlatformCustomDomainOperationSource(ArmClient client)
        {
            _client = client;
        }

        AppPlatformCustomDomainResource IOperationSource<AppPlatformCustomDomainResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AppPlatformCustomDomainData.DeserializeAppPlatformCustomDomainData(document.RootElement);
            return new AppPlatformCustomDomainResource(_client, data);
        }

        async ValueTask<AppPlatformCustomDomainResource> IOperationSource<AppPlatformCustomDomainResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AppPlatformCustomDomainData.DeserializeAppPlatformCustomDomainData(document.RootElement);
            return new AppPlatformCustomDomainResource(_client, data);
        }
    }
}
