// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppPlatform
{
    internal class AppPlatformConfigurationServiceOperationSource : IOperationSource<AppPlatformConfigurationServiceResource>
    {
        private readonly ArmClient _client;

        internal AppPlatformConfigurationServiceOperationSource(ArmClient client)
        {
            _client = client;
        }

        AppPlatformConfigurationServiceResource IOperationSource<AppPlatformConfigurationServiceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AppPlatformConfigurationServiceData.DeserializeAppPlatformConfigurationServiceData(document.RootElement);
            return new AppPlatformConfigurationServiceResource(_client, data);
        }

        async ValueTask<AppPlatformConfigurationServiceResource> IOperationSource<AppPlatformConfigurationServiceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AppPlatformConfigurationServiceData.DeserializeAppPlatformConfigurationServiceData(document.RootElement);
            return new AppPlatformConfigurationServiceResource(_client, data);
        }
    }
}
