// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppPlatform
{
    internal class AppPlatformConfigServerOperationSource : IOperationSource<AppPlatformConfigServerResource>
    {
        private readonly ArmClient _client;

        internal AppPlatformConfigServerOperationSource(ArmClient client)
        {
            _client = client;
        }

        AppPlatformConfigServerResource IOperationSource<AppPlatformConfigServerResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AppPlatformConfigServerData.DeserializeAppPlatformConfigServerData(document.RootElement);
            return new AppPlatformConfigServerResource(_client, data);
        }

        async ValueTask<AppPlatformConfigServerResource> IOperationSource<AppPlatformConfigServerResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AppPlatformConfigServerData.DeserializeAppPlatformConfigServerData(document.RootElement);
            return new AppPlatformConfigServerResource(_client, data);
        }
    }
}
