// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppPlatform
{
    internal class AppPlatformCertificateOperationSource : IOperationSource<AppPlatformCertificateResource>
    {
        private readonly ArmClient _client;

        internal AppPlatformCertificateOperationSource(ArmClient client)
        {
            _client = client;
        }

        AppPlatformCertificateResource IOperationSource<AppPlatformCertificateResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AppPlatformCertificateData.DeserializeAppPlatformCertificateData(document.RootElement);
            return new AppPlatformCertificateResource(_client, data);
        }

        async ValueTask<AppPlatformCertificateResource> IOperationSource<AppPlatformCertificateResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AppPlatformCertificateData.DeserializeAppPlatformCertificateData(document.RootElement);
            return new AppPlatformCertificateResource(_client, data);
        }
    }
}
