// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppPlatform
{
    internal class AppPlatformBuildpackBindingOperationSource : IOperationSource<AppPlatformBuildpackBindingResource>
    {
        private readonly ArmClient _client;

        internal AppPlatformBuildpackBindingOperationSource(ArmClient client)
        {
            _client = client;
        }

        AppPlatformBuildpackBindingResource IOperationSource<AppPlatformBuildpackBindingResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AppPlatformBuildpackBindingData.DeserializeAppPlatformBuildpackBindingData(document.RootElement);
            return new AppPlatformBuildpackBindingResource(_client, data);
        }

        async ValueTask<AppPlatformBuildpackBindingResource> IOperationSource<AppPlatformBuildpackBindingResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AppPlatformBuildpackBindingData.DeserializeAppPlatformBuildpackBindingData(document.RootElement);
            return new AppPlatformBuildpackBindingResource(_client, data);
        }
    }
}
