// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppPlatform
{
    internal class AppPlatformBuildServiceAgentPoolOperationSource : IOperationSource<AppPlatformBuildServiceAgentPoolResource>
    {
        private readonly ArmClient _client;

        internal AppPlatformBuildServiceAgentPoolOperationSource(ArmClient client)
        {
            _client = client;
        }

        AppPlatformBuildServiceAgentPoolResource IOperationSource<AppPlatformBuildServiceAgentPoolResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AppPlatformBuildServiceAgentPoolData.DeserializeAppPlatformBuildServiceAgentPoolData(document.RootElement);
            return new AppPlatformBuildServiceAgentPoolResource(_client, data);
        }

        async ValueTask<AppPlatformBuildServiceAgentPoolResource> IOperationSource<AppPlatformBuildServiceAgentPoolResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AppPlatformBuildServiceAgentPoolData.DeserializeAppPlatformBuildServiceAgentPoolData(document.RootElement);
            return new AppPlatformBuildServiceAgentPoolResource(_client, data);
        }
    }
}
