// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppPlatform
{
    internal class AppPlatformBindingOperationSource : IOperationSource<AppPlatformBindingResource>
    {
        private readonly ArmClient _client;

        internal AppPlatformBindingOperationSource(ArmClient client)
        {
            _client = client;
        }

        AppPlatformBindingResource IOperationSource<AppPlatformBindingResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AppPlatformBindingData.DeserializeAppPlatformBindingData(document.RootElement);
            return new AppPlatformBindingResource(_client, data);
        }

        async ValueTask<AppPlatformBindingResource> IOperationSource<AppPlatformBindingResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AppPlatformBindingData.DeserializeAppPlatformBindingData(document.RootElement);
            return new AppPlatformBindingResource(_client, data);
        }
    }
}
