// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppPlatform
{
    internal class AppPlatformAppOperationSource : IOperationSource<AppPlatformAppResource>
    {
        private readonly ArmClient _client;

        internal AppPlatformAppOperationSource(ArmClient client)
        {
            _client = client;
        }

        AppPlatformAppResource IOperationSource<AppPlatformAppResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AppPlatformAppData.DeserializeAppPlatformAppData(document.RootElement);
            return new AppPlatformAppResource(_client, data);
        }

        async ValueTask<AppPlatformAppResource> IOperationSource<AppPlatformAppResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AppPlatformAppData.DeserializeAppPlatformAppData(document.RootElement);
            return new AppPlatformAppResource(_client, data);
        }
    }
}
