// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppPlatform
{
    internal class AppPlatformApiPortalOperationSource : IOperationSource<AppPlatformApiPortalResource>
    {
        private readonly ArmClient _client;

        internal AppPlatformApiPortalOperationSource(ArmClient client)
        {
            _client = client;
        }

        AppPlatformApiPortalResource IOperationSource<AppPlatformApiPortalResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AppPlatformApiPortalData.DeserializeAppPlatformApiPortalData(document.RootElement);
            return new AppPlatformApiPortalResource(_client, data);
        }

        async ValueTask<AppPlatformApiPortalResource> IOperationSource<AppPlatformApiPortalResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AppPlatformApiPortalData.DeserializeAppPlatformApiPortalData(document.RootElement);
            return new AppPlatformApiPortalResource(_client, data);
        }
    }
}
