// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AppPlatform
{
    internal class AppPlatformApiPortalCustomDomainOperationSource : IOperationSource<AppPlatformApiPortalCustomDomainResource>
    {
        private readonly ArmClient _client;

        internal AppPlatformApiPortalCustomDomainOperationSource(ArmClient client)
        {
            _client = client;
        }

        AppPlatformApiPortalCustomDomainResource IOperationSource<AppPlatformApiPortalCustomDomainResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AppPlatformApiPortalCustomDomainData.DeserializeAppPlatformApiPortalCustomDomainData(document.RootElement);
            return new AppPlatformApiPortalCustomDomainResource(_client, data);
        }

        async ValueTask<AppPlatformApiPortalCustomDomainResource> IOperationSource<AppPlatformApiPortalCustomDomainResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AppPlatformApiPortalCustomDomainData.DeserializeAppPlatformApiPortalCustomDomainData(document.RootElement);
            return new AppPlatformApiPortalCustomDomainResource(_client, data);
        }
    }
}
