// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.AppPlatform.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmAppPlatformModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformServiceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> Properties of the Service resource. </param>
        /// <param name="sku"> Sku of the Service resource. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformServiceData"/> instance for mocking. </returns>
        public static AppPlatformServiceData AppPlatformServiceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, AppPlatformServiceProperties properties = null, AppPlatformSku sku = null)
        {
            tags ??= new Dictionary<string, string>();

            return new AppPlatformServiceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                sku,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformServiceProperties"/>. </summary>
        /// <param name="provisioningState"> Provisioning state of the Service. </param>
        /// <param name="networkProfile"> Network profile of the Service. </param>
        /// <param name="isLogStreamPublicEndpoint"> Additional Service settings in vnet injection instance. </param>
        /// <param name="version"> Version of the Service. </param>
        /// <param name="serviceInstanceId"> ServiceInstanceEntity GUID which uniquely identifies a created resource. </param>
        /// <param name="powerState"> Power state of the Service. </param>
        /// <param name="isZoneRedundant"></param>
        /// <param name="fqdn"> Fully qualified dns name of the service instance. </param>
        /// <returns> A new <see cref="Models.AppPlatformServiceProperties"/> instance for mocking. </returns>
        public static AppPlatformServiceProperties AppPlatformServiceProperties(AppPlatformServiceProvisioningState? provisioningState = null, AppPlatformServiceNetworkProfile networkProfile = null, bool? isLogStreamPublicEndpoint = null, int? version = null, string serviceInstanceId = null, AppPlatformServicePowerState? powerState = null, bool? isZoneRedundant = null, string fqdn = null)
        {
            return new AppPlatformServiceProperties(
                provisioningState,
                networkProfile,
                isLogStreamPublicEndpoint != null ? new ServiceVnetAddons(isLogStreamPublicEndpoint, serializedAdditionalRawData: null) : null,
                version,
                serviceInstanceId,
                powerState,
                isZoneRedundant,
                fqdn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformServiceNetworkProfile"/>. </summary>
        /// <param name="serviceRuntimeSubnetId"> Fully qualified resource Id of the subnet to host Azure Spring Apps Service Runtime. </param>
        /// <param name="appSubnetId"> Fully qualified resource Id of the subnet to host customer apps in Azure Spring Apps. </param>
        /// <param name="serviceCidr"> Azure Spring Apps service reserved CIDR. </param>
        /// <param name="serviceRuntimeNetworkResourceGroup"> Name of the resource group containing network resources of Azure Spring Apps Service Runtime. </param>
        /// <param name="appNetworkResourceGroup"> Name of the resource group containing network resources for customer apps in Azure Spring Apps. </param>
        /// <param name="outboundPublicIPs"> Desired outbound IP resources for Azure Spring Apps resource. </param>
        /// <param name="requiredTraffics"> Required inbound or outbound traffics for Azure Spring Apps resource. </param>
        /// <param name="ingressConfigReadTimeoutInSeconds"> Ingress configuration payload for Azure Spring Apps resource. </param>
        /// <param name="outboundType"> The egress traffic type of Azure Spring Apps VNet instances. </param>
        /// <returns> A new <see cref="Models.AppPlatformServiceNetworkProfile"/> instance for mocking. </returns>
        public static AppPlatformServiceNetworkProfile AppPlatformServiceNetworkProfile(ResourceIdentifier serviceRuntimeSubnetId = null, ResourceIdentifier appSubnetId = null, string serviceCidr = null, string serviceRuntimeNetworkResourceGroup = null, string appNetworkResourceGroup = null, IEnumerable<IPAddress> outboundPublicIPs = null, IEnumerable<AppPlatformServiceRequiredTraffic> requiredTraffics = null, int? ingressConfigReadTimeoutInSeconds = null, string outboundType = null)
        {
            outboundPublicIPs ??= new List<IPAddress>();
            requiredTraffics ??= new List<AppPlatformServiceRequiredTraffic>();

            return new AppPlatformServiceNetworkProfile(
                serviceRuntimeSubnetId,
                appSubnetId,
                serviceCidr,
                serviceRuntimeNetworkResourceGroup,
                appNetworkResourceGroup,
                outboundPublicIPs != null ? new NetworkProfileOutboundIPs(outboundPublicIPs?.ToList(), serializedAdditionalRawData: null) : null,
                requiredTraffics?.ToList(),
                ingressConfigReadTimeoutInSeconds != null ? new IngressConfig(ingressConfigReadTimeoutInSeconds, serializedAdditionalRawData: null) : null,
                outboundType,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformServiceRequiredTraffic"/>. </summary>
        /// <param name="protocol"> The protocol of required traffic. </param>
        /// <param name="port"> The port of required traffic. </param>
        /// <param name="ips"> The ip list of required traffic. </param>
        /// <param name="fqdns"> The FQDN list of required traffic. </param>
        /// <param name="direction"> The direction of required traffic. </param>
        /// <returns> A new <see cref="Models.AppPlatformServiceRequiredTraffic"/> instance for mocking. </returns>
        public static AppPlatformServiceRequiredTraffic AppPlatformServiceRequiredTraffic(string protocol = null, int? port = null, IEnumerable<IPAddress> ips = null, IEnumerable<string> fqdns = null, AppPlatformServiceTrafficDirection? direction = null)
        {
            ips ??= new List<IPAddress>();
            fqdns ??= new List<string>();

            return new AppPlatformServiceRequiredTraffic(
                protocol,
                port,
                ips?.ToList(),
                fqdns?.ToList(),
                direction,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformServiceTestKeys"/>. </summary>
        /// <param name="primaryKey"> Primary key. </param>
        /// <param name="secondaryKey"> Secondary key. </param>
        /// <param name="primaryTestEndpoint"> Primary test endpoint. </param>
        /// <param name="secondaryTestEndpoint"> Secondary test endpoint. </param>
        /// <param name="isEnabled"> Indicates whether the test endpoint feature enabled or not. </param>
        /// <returns> A new <see cref="Models.AppPlatformServiceTestKeys"/> instance for mocking. </returns>
        public static AppPlatformServiceTestKeys AppPlatformServiceTestKeys(string primaryKey = null, string secondaryKey = null, string primaryTestEndpoint = null, string secondaryTestEndpoint = null, bool? isEnabled = null)
        {
            return new AppPlatformServiceTestKeys(
                primaryKey,
                secondaryKey,
                primaryTestEndpoint,
                secondaryTestEndpoint,
                isEnabled,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformConfigServerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Properties of the Config Server resource. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformConfigServerData"/> instance for mocking. </returns>
        public static AppPlatformConfigServerData AppPlatformConfigServerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AppPlatformConfigServerProperties properties = null)
        {
            return new AppPlatformConfigServerData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformConfigServerProperties"/>. </summary>
        /// <param name="provisioningState"> State of the config server. </param>
        /// <param name="error"> Error when apply config server settings. </param>
        /// <param name="configServerGitProperty"> Settings of config server. </param>
        /// <returns> A new <see cref="Models.AppPlatformConfigServerProperties"/> instance for mocking. </returns>
        public static AppPlatformConfigServerProperties AppPlatformConfigServerProperties(AppPlatformConfigServerState? provisioningState = null, AppPlatformErrorInfo error = null, AppPlatformConfigServerGitProperty configServerGitProperty = null)
        {
            return new AppPlatformConfigServerProperties(provisioningState, error, configServerGitProperty != null ? new ConfigServerSettings(configServerGitProperty, serializedAdditionalRawData: null) : null, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConfigServerSettingsValidateResult"/>. </summary>
        /// <param name="isValid"> Indicate if the config server settings are valid. </param>
        /// <param name="details"> The detail validation results. </param>
        /// <returns> A new <see cref="Models.ConfigServerSettingsValidateResult"/> instance for mocking. </returns>
        public static ConfigServerSettingsValidateResult ConfigServerSettingsValidateResult(bool? isValid = null, IEnumerable<ConfigServerSettingsErrorRecord> details = null)
        {
            details ??= new List<ConfigServerSettingsErrorRecord>();

            return new ConfigServerSettingsValidateResult(isValid, details?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConfigServerSettingsErrorRecord"/>. </summary>
        /// <param name="name"> The name of the config server settings error record. </param>
        /// <param name="uri"> The uri of the config server settings error record. </param>
        /// <param name="messages"> The detail error messages of the record. </param>
        /// <returns> A new <see cref="Models.ConfigServerSettingsErrorRecord"/> instance for mocking. </returns>
        public static ConfigServerSettingsErrorRecord ConfigServerSettingsErrorRecord(string name = null, Uri uri = null, IEnumerable<string> messages = null)
        {
            messages ??= new List<string>();

            return new ConfigServerSettingsErrorRecord(name, uri, messages?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformConfigurationServiceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Application Configuration Service properties payload. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformConfigurationServiceData"/> instance for mocking. </returns>
        public static AppPlatformConfigurationServiceData AppPlatformConfigurationServiceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AppPlatformConfigurationServiceProperties properties = null)
        {
            return new AppPlatformConfigurationServiceData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformConfigurationServiceProperties"/>. </summary>
        /// <param name="provisioningState"> State of the Application Configuration Service. </param>
        /// <param name="resourceRequests"> The requested resource quantity for required CPU and Memory. </param>
        /// <param name="instances"> Collection of instances belong to Application Configuration Service. </param>
        /// <param name="configurationServiceGitRepositories"> The settings of Application Configuration Service. </param>
        /// <returns> A new <see cref="Models.AppPlatformConfigurationServiceProperties"/> instance for mocking. </returns>
        public static AppPlatformConfigurationServiceProperties AppPlatformConfigurationServiceProperties(AppPlatformConfigurationServiceProvisioningState? provisioningState = null, AppPlatformConfigurationServiceRequirements resourceRequests = null, IEnumerable<AppPlatformConfigurationServiceInstance> instances = null, IEnumerable<AppPlatformConfigurationServiceGitRepository> configurationServiceGitRepositories = null)
        {
            instances ??= new List<AppPlatformConfigurationServiceInstance>();
            configurationServiceGitRepositories ??= new List<AppPlatformConfigurationServiceGitRepository>();

            return new AppPlatformConfigurationServiceProperties(provisioningState, resourceRequests, instances?.ToList(), configurationServiceGitRepositories != null ? new AppPlatformConfigurationServiceSettings(new ConfigurationServiceGitProperty(configurationServiceGitRepositories?.ToList(), serializedAdditionalRawData: null), serializedAdditionalRawData: null) : null, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformConfigurationServiceRequirements"/>. </summary>
        /// <param name="cpu"> Cpu allocated to each Application Configuration Service instance. </param>
        /// <param name="memory"> Memory allocated to each Application Configuration Service instance. </param>
        /// <param name="instanceCount"> Instance count of the Application Configuration Service. </param>
        /// <returns> A new <see cref="Models.AppPlatformConfigurationServiceRequirements"/> instance for mocking. </returns>
        public static AppPlatformConfigurationServiceRequirements AppPlatformConfigurationServiceRequirements(string cpu = null, string memory = null, int? instanceCount = null)
        {
            return new AppPlatformConfigurationServiceRequirements(cpu, memory, instanceCount, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformConfigurationServiceInstance"/>. </summary>
        /// <param name="name"> Name of the Application Configuration Service instance. </param>
        /// <param name="status"> Status of the Application Configuration Service instance. </param>
        /// <returns> A new <see cref="Models.AppPlatformConfigurationServiceInstance"/> instance for mocking. </returns>
        public static AppPlatformConfigurationServiceInstance AppPlatformConfigurationServiceInstance(string name = null, string status = null)
        {
            return new AppPlatformConfigurationServiceInstance(name, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformConfigurationServiceSettingsValidateResult"/>. </summary>
        /// <param name="gitPropertyValidationResult"> Validation result for configuration service settings. </param>
        /// <returns> A new <see cref="Models.AppPlatformConfigurationServiceSettingsValidateResult"/> instance for mocking. </returns>
        public static AppPlatformConfigurationServiceSettingsValidateResult AppPlatformConfigurationServiceSettingsValidateResult(AppPlatformConfigurationServiceGitValidateResult gitPropertyValidationResult = null)
        {
            return new AppPlatformConfigurationServiceSettingsValidateResult(gitPropertyValidationResult, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformConfigurationServiceGitValidateResult"/>. </summary>
        /// <param name="isValid"> Indicate if the configuration service settings are valid. </param>
        /// <param name="gitReposValidationResult"> The detail validation results. </param>
        /// <returns> A new <see cref="Models.AppPlatformConfigurationServiceGitValidateResult"/> instance for mocking. </returns>
        public static AppPlatformConfigurationServiceGitValidateResult AppPlatformConfigurationServiceGitValidateResult(bool? isValid = null, IEnumerable<AppPlatformConfigurationServiceGitReposValidationMessages> gitReposValidationResult = null)
        {
            gitReposValidationResult ??= new List<AppPlatformConfigurationServiceGitReposValidationMessages>();

            return new AppPlatformConfigurationServiceGitValidateResult(isValid, gitReposValidationResult?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformConfigurationServiceGitReposValidationMessages"/>. </summary>
        /// <param name="name"> The name of the configuration service git repository. </param>
        /// <param name="messages"> Detailed validation messages. </param>
        /// <returns> A new <see cref="Models.AppPlatformConfigurationServiceGitReposValidationMessages"/> instance for mocking. </returns>
        public static AppPlatformConfigurationServiceGitReposValidationMessages AppPlatformConfigurationServiceGitReposValidationMessages(string name = null, IEnumerable<string> messages = null)
        {
            messages ??= new List<string>();

            return new AppPlatformConfigurationServiceGitReposValidationMessages(name, messages?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformServiceRegistryData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Service Registry properties payload. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformServiceRegistryData"/> instance for mocking. </returns>
        public static AppPlatformServiceRegistryData AppPlatformServiceRegistryData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AppPlatformServiceRegistryProperties properties = null)
        {
            return new AppPlatformServiceRegistryData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformServiceRegistryProperties"/>. </summary>
        /// <param name="provisioningState"> State of the Service Registry. </param>
        /// <param name="resourceRequests"> The requested resource quantity for required CPU and Memory. </param>
        /// <param name="instances"> Collection of instances belong to Service Registry. </param>
        /// <returns> A new <see cref="Models.AppPlatformServiceRegistryProperties"/> instance for mocking. </returns>
        public static AppPlatformServiceRegistryProperties AppPlatformServiceRegistryProperties(AppPlatformServiceRegistryProvisioningState? provisioningState = null, AppPlatformServiceRegistryResourceRequirements resourceRequests = null, IEnumerable<AppPlatformServiceRegistryInstance> instances = null)
        {
            instances ??= new List<AppPlatformServiceRegistryInstance>();

            return new AppPlatformServiceRegistryProperties(provisioningState, resourceRequests, instances?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformServiceRegistryResourceRequirements"/>. </summary>
        /// <param name="cpu"> Cpu allocated to each Service Registry instance. </param>
        /// <param name="memory"> Memory allocated to each Service Registry instance. </param>
        /// <param name="instanceCount"> Instance count of the Service Registry. </param>
        /// <returns> A new <see cref="Models.AppPlatformServiceRegistryResourceRequirements"/> instance for mocking. </returns>
        public static AppPlatformServiceRegistryResourceRequirements AppPlatformServiceRegistryResourceRequirements(string cpu = null, string memory = null, int? instanceCount = null)
        {
            return new AppPlatformServiceRegistryResourceRequirements(cpu, memory, instanceCount, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformServiceRegistryInstance"/>. </summary>
        /// <param name="name"> Name of the Service Registry instance. </param>
        /// <param name="status"> Status of the Service Registry instance. </param>
        /// <returns> A new <see cref="Models.AppPlatformServiceRegistryInstance"/> instance for mocking. </returns>
        public static AppPlatformServiceRegistryInstance AppPlatformServiceRegistryInstance(string name = null, string status = null)
        {
            return new AppPlatformServiceRegistryInstance(name, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformBuildServiceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Properties of the build resource. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformBuildServiceData"/> instance for mocking. </returns>
        public static AppPlatformBuildServiceData AppPlatformBuildServiceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AppPlatformBuildServiceProperties properties = null)
        {
            return new AppPlatformBuildServiceData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformBuildServiceProperties"/>. </summary>
        /// <param name="kPackVersion"> The installed KPack version in this build service. </param>
        /// <param name="provisioningState"> Provisioning state of the KPack build result. </param>
        /// <param name="resourceRequests"> The runtime resource configuration of this build service. </param>
        /// <returns> A new <see cref="Models.AppPlatformBuildServiceProperties"/> instance for mocking. </returns>
        public static AppPlatformBuildServiceProperties AppPlatformBuildServiceProperties(string kPackVersion = null, AppPlatformBuildServiceProvisioningState? provisioningState = null, AppPlatformBuildServiceResourceRequirements resourceRequests = null)
        {
            return new AppPlatformBuildServiceProperties(kPackVersion, provisioningState, resourceRequests, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformBuildServiceResourceRequirements"/>. </summary>
        /// <param name="cpu"> vCPU allocated to the entire build service node pool. </param>
        /// <param name="memory"> Memory allocated to the entire build service node pool. </param>
        /// <returns> A new <see cref="Models.AppPlatformBuildServiceResourceRequirements"/> instance for mocking. </returns>
        public static AppPlatformBuildServiceResourceRequirements AppPlatformBuildServiceResourceRequirements(string cpu = null, string memory = null)
        {
            return new AppPlatformBuildServiceResourceRequirements(cpu, memory, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformBuildData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Properties of the build resource. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformBuildData"/> instance for mocking. </returns>
        public static AppPlatformBuildData AppPlatformBuildData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AppPlatformBuildProperties properties = null)
        {
            return new AppPlatformBuildData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformBuildProperties"/>. </summary>
        /// <param name="relativePath"> The relative path of source code. </param>
        /// <param name="builder"> The resource id of builder to build the source code. </param>
        /// <param name="agentPool"> The resource id of agent pool. </param>
        /// <param name="provisioningState"> Provisioning state of the KPack build result. </param>
        /// <param name="env"> The environment variables for this build. </param>
        /// <param name="triggeredBuildResultId"> The build result triggered by this build. </param>
        /// <param name="resourceRequests"> The customized build resource for this build. </param>
        /// <returns> A new <see cref="Models.AppPlatformBuildProperties"/> instance for mocking. </returns>
        public static AppPlatformBuildProperties AppPlatformBuildProperties(string relativePath = null, string builder = null, string agentPool = null, AppPlatformBuildProvisioningState? provisioningState = null, IDictionary<string, string> env = null, ResourceIdentifier triggeredBuildResultId = null, AppPlatformBuildResourceRequirements resourceRequests = null)
        {
            env ??= new Dictionary<string, string>();

            return new AppPlatformBuildProperties(
                relativePath,
                builder,
                agentPool,
                provisioningState,
                env,
                triggeredBuildResultId != null ? ResourceManagerModelFactory.SubResource(triggeredBuildResultId) : null,
                resourceRequests,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformBuildpackBindingData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Properties of a buildpack binding. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformBuildpackBindingData"/> instance for mocking. </returns>
        public static AppPlatformBuildpackBindingData AppPlatformBuildpackBindingData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AppPlatformBuildpackBindingProperties properties = null)
        {
            return new AppPlatformBuildpackBindingData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformBuildpackBindingProperties"/>. </summary>
        /// <param name="bindingType"> Buildpack Binding Type. </param>
        /// <param name="provisioningState"> State of the Buildpack Binding. </param>
        /// <param name="launchProperties"> The object describes the buildpack binding launch properties. </param>
        /// <returns> A new <see cref="Models.AppPlatformBuildpackBindingProperties"/> instance for mocking. </returns>
        public static AppPlatformBuildpackBindingProperties AppPlatformBuildpackBindingProperties(BuildpackBindingType? bindingType = null, BuildpackBindingProvisioningState? provisioningState = null, BuildpackBindingLaunchProperties launchProperties = null)
        {
            return new AppPlatformBuildpackBindingProperties(bindingType, provisioningState, launchProperties, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformBuildResultData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Properties of the build result resource. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformBuildResultData"/> instance for mocking. </returns>
        public static AppPlatformBuildResultData AppPlatformBuildResultData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AppPlatformBuildResultProperties properties = null)
        {
            return new AppPlatformBuildResultData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformBuildResultProperties"/>. </summary>
        /// <param name="name"> The name of this build result. </param>
        /// <param name="provisioningState"> Provisioning state of the KPack build result. </param>
        /// <param name="buildPodName"> The build pod name which can be used to get the build log streaming. </param>
        /// <param name="buildStages"> All of the build stage (init-container and container) resources in build pod. </param>
        /// <returns> A new <see cref="Models.AppPlatformBuildResultProperties"/> instance for mocking. </returns>
        public static AppPlatformBuildResultProperties AppPlatformBuildResultProperties(string name = null, AppPlatformBuildResultProvisioningState? provisioningState = null, string buildPodName = null, IEnumerable<AppPlatformBuildStageProperties> buildStages = null)
        {
            buildStages ??= new List<AppPlatformBuildStageProperties>();

            return new AppPlatformBuildResultProperties(name, provisioningState, buildPodName, buildStages?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformBuildStageProperties"/>. </summary>
        /// <param name="name"> The name of this build stage resource. </param>
        /// <param name="status"> The provisioning state of this build stage resource. </param>
        /// <returns> A new <see cref="Models.AppPlatformBuildStageProperties"/> instance for mocking. </returns>
        public static AppPlatformBuildStageProperties AppPlatformBuildStageProperties(string name = null, KPackBuildStageProvisioningState? status = null)
        {
            return new AppPlatformBuildStageProperties(name, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformBuildResultLog"/>. </summary>
        /// <param name="blobUri"> The public download URL of this build result log. </param>
        /// <returns> A new <see cref="Models.AppPlatformBuildResultLog"/> instance for mocking. </returns>
        public static AppPlatformBuildResultLog AppPlatformBuildResultLog(Uri blobUri = null)
        {
            return new AppPlatformBuildResultLog(blobUri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformBuilderData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Property of the Builder resource. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformBuilderData"/> instance for mocking. </returns>
        public static AppPlatformBuilderData AppPlatformBuilderData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AppPlatformBuilderProperties properties = null)
        {
            return new AppPlatformBuilderData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformBuilderProperties"/>. </summary>
        /// <param name="provisioningState"> Builder provision status. </param>
        /// <param name="stack"> Builder cluster stack property. </param>
        /// <param name="buildpackGroups"> Builder buildpack groups. </param>
        /// <returns> A new <see cref="Models.AppPlatformBuilderProperties"/> instance for mocking. </returns>
        public static AppPlatformBuilderProperties AppPlatformBuilderProperties(AppPlatformBuilderProvisioningState? provisioningState = null, AppPlatformClusterStackProperties stack = null, IEnumerable<BuildpacksGroupProperties> buildpackGroups = null)
        {
            buildpackGroups ??= new List<BuildpacksGroupProperties>();

            return new AppPlatformBuilderProperties(provisioningState, stack, buildpackGroups?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformResourceUploadResult"/>. </summary>
        /// <param name="relativePath"> Source relative path. </param>
        /// <param name="uploadUri"> Upload URL. </param>
        /// <returns> A new <see cref="Models.AppPlatformResourceUploadResult"/> instance for mocking. </returns>
        public static AppPlatformResourceUploadResult AppPlatformResourceUploadResult(string relativePath = null, Uri uploadUri = null)
        {
            return new AppPlatformResourceUploadResult(relativePath, uploadUri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformSupportedBuildpackData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="supportedBuildpackId"> Supported buildpack resource properties. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformSupportedBuildpackData"/> instance for mocking. </returns>
        public static AppPlatformSupportedBuildpackData AppPlatformSupportedBuildpackData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string supportedBuildpackId = null)
        {
            return new AppPlatformSupportedBuildpackData(
                id,
                name,
                resourceType,
                systemData,
                supportedBuildpackId != null ? new SupportedBuildpackResourceProperties(supportedBuildpackId, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformSupportedStackData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Supported stack resource properties. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformSupportedStackData"/> instance for mocking. </returns>
        public static AppPlatformSupportedStackData AppPlatformSupportedStackData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AppPlatformSupportedStackProperties properties = null)
        {
            return new AppPlatformSupportedStackData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformBuildServiceAgentPoolData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> build service agent pool properties. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformBuildServiceAgentPoolData"/> instance for mocking. </returns>
        public static AppPlatformBuildServiceAgentPoolData AppPlatformBuildServiceAgentPoolData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AppPlatformBuildServiceAgentPoolProperties properties = null)
        {
            return new AppPlatformBuildServiceAgentPoolData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformBuildServiceAgentPoolProperties"/>. </summary>
        /// <param name="provisioningState"> Provisioning state of the build service agent pool. </param>
        /// <param name="poolSize"> build service agent pool size properties. </param>
        /// <returns> A new <see cref="Models.AppPlatformBuildServiceAgentPoolProperties"/> instance for mocking. </returns>
        public static AppPlatformBuildServiceAgentPoolProperties AppPlatformBuildServiceAgentPoolProperties(string provisioningState = null, BuildServiceAgentPoolSizeProperties poolSize = null)
        {
            return new AppPlatformBuildServiceAgentPoolProperties(provisioningState, poolSize, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BuildServiceAgentPoolSizeProperties"/>. </summary>
        /// <param name="name"> The name of build service agent pool size. </param>
        /// <param name="cpu"> The cpu property of build service agent pool size. </param>
        /// <param name="memory"> The memory property of build service agent pool size. </param>
        /// <returns> A new <see cref="Models.BuildServiceAgentPoolSizeProperties"/> instance for mocking. </returns>
        public static BuildServiceAgentPoolSizeProperties BuildServiceAgentPoolSizeProperties(string name = null, string cpu = null, string memory = null)
        {
            return new BuildServiceAgentPoolSizeProperties(name, cpu, memory, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformMonitoringSettingData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Properties of the Monitoring Setting resource. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformMonitoringSettingData"/> instance for mocking. </returns>
        public static AppPlatformMonitoringSettingData AppPlatformMonitoringSettingData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AppPlatformMonitoringSettingProperties properties = null)
        {
            return new AppPlatformMonitoringSettingData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformMonitoringSettingProperties"/>. </summary>
        /// <param name="provisioningState"> State of the Monitoring Setting. </param>
        /// <param name="error"> Error when apply Monitoring Setting changes. </param>
        /// <param name="isTraceEnabled"> Indicates whether enable the trace functionality, which will be deprecated since api version 2020-11-01-preview. Please leverage appInsightsInstrumentationKey to indicate if monitoringSettings enabled or not. </param>
        /// <param name="appInsightsInstrumentationKey"> Target application insight instrumentation key, null or whitespace include empty will disable monitoringSettings. </param>
        /// <param name="appInsightsSamplingRate"> Indicates the sampling rate of application insight agent, should be in range [0.0, 100.0]. </param>
        /// <param name="appInsightsJavaAgentVersion"> Indicates the versions of application insight agent. </param>
        /// <returns> A new <see cref="Models.AppPlatformMonitoringSettingProperties"/> instance for mocking. </returns>
        public static AppPlatformMonitoringSettingProperties AppPlatformMonitoringSettingProperties(AppPlatformMonitoringSettingState? provisioningState = null, AppPlatformErrorInfo error = null, bool? isTraceEnabled = null, string appInsightsInstrumentationKey = null, double? appInsightsSamplingRate = null, string appInsightsJavaAgentVersion = null)
        {
            return new AppPlatformMonitoringSettingProperties(
                provisioningState,
                error,
                isTraceEnabled,
                appInsightsInstrumentationKey,
                appInsightsSamplingRate,
                appInsightsJavaAgentVersion != null ? new ApplicationInsightsAgentVersions(appInsightsJavaAgentVersion, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformAppData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Properties of the App resource. </param>
        /// <param name="identity"> The Managed Identity type of the app resource. </param>
        /// <param name="location"> The GEO location of the application, always the same with its parent resource. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformAppData"/> instance for mocking. </returns>
        public static AppPlatformAppData AppPlatformAppData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AppPlatformAppProperties properties = null, ManagedServiceIdentity identity = null, AzureLocation? location = null)
        {
            return new AppPlatformAppData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                identity,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformAppProperties"/>. </summary>
        /// <param name="isPublic"> Indicates whether the App exposes public endpoint. </param>
        /// <param name="uriString"> URL of the App. </param>
        /// <param name="addonConfigs"> Collection of addons. </param>
        /// <param name="provisioningState"> Provisioning state of the App. </param>
        /// <param name="fqdn"> Fully qualified dns Name. </param>
        /// <param name="isHttpsOnly"> Indicate if only https is allowed. </param>
        /// <param name="temporaryDisk"> Temporary disk settings. </param>
        /// <param name="persistentDisk"> Persistent disk settings. </param>
        /// <param name="customPersistentDisks"> List of custom persistent disks. </param>
        /// <param name="isEndToEndTlsEnabled"> Indicate if end to end TLS is enabled. </param>
        /// <param name="loadedCertificates"> Collection of loaded certificates. </param>
        /// <param name="vnetAddons"> Additional App settings in vnet injection instance. </param>
        /// <param name="ingressSettings"> App ingress settings payload. </param>
        /// <returns> A new <see cref="Models.AppPlatformAppProperties"/> instance for mocking. </returns>
        public static AppPlatformAppProperties AppPlatformAppProperties(bool? isPublic = null, string uriString = null, IDictionary<string, IDictionary<string, BinaryData>> addonConfigs = null, AppPlatformAppProvisioningState? provisioningState = null, string fqdn = null, bool? isHttpsOnly = null, AppTemporaryDisk temporaryDisk = null, AppPersistentDisk persistentDisk = null, IEnumerable<AppCustomPersistentDisk> customPersistentDisks = null, bool? isEndToEndTlsEnabled = null, IEnumerable<AppLoadedCertificate> loadedCertificates = null, AppVnetAddons vnetAddons = null, AppIngressSettings ingressSettings = null)
        {
            addonConfigs ??= new Dictionary<string, IDictionary<string, BinaryData>>();
            customPersistentDisks ??= new List<AppCustomPersistentDisk>();
            loadedCertificates ??= new List<AppLoadedCertificate>();

            return new AppPlatformAppProperties(
                isPublic,
                uriString,
                addonConfigs,
                provisioningState,
                fqdn,
                isHttpsOnly,
                temporaryDisk,
                persistentDisk,
                customPersistentDisks?.ToList(),
                isEndToEndTlsEnabled,
                loadedCertificates?.ToList(),
                vnetAddons,
                ingressSettings,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPersistentDisk"/>. </summary>
        /// <param name="sizeInGB"> Size of the persistent disk in GB. </param>
        /// <param name="usedInGB"> Size of the used persistent disk in GB. </param>
        /// <param name="mountPath"> Mount path of the persistent disk. </param>
        /// <returns> A new <see cref="Models.AppPersistentDisk"/> instance for mocking. </returns>
        public static AppPersistentDisk AppPersistentDisk(int? sizeInGB = null, int? usedInGB = null, string mountPath = null)
        {
            return new AppPersistentDisk(sizeInGB, usedInGB, mountPath, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppVnetAddons"/>. </summary>
        /// <param name="isPublicEndpoint"> Indicates whether the App in vnet injection instance exposes endpoint which could be accessed from internet. </param>
        /// <param name="publicEndpointUri"> URL of the App in vnet injection instance which could be accessed from internet. </param>
        /// <returns> A new <see cref="Models.AppVnetAddons"/> instance for mocking. </returns>
        public static AppVnetAddons AppVnetAddons(bool? isPublicEndpoint = null, Uri publicEndpointUri = null)
        {
            return new AppVnetAddons(isPublicEndpoint, publicEndpointUri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformBindingData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Properties of the Binding resource. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformBindingData"/> instance for mocking. </returns>
        public static AppPlatformBindingData AppPlatformBindingData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AppPlatformBindingProperties properties = null)
        {
            return new AppPlatformBindingData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformBindingProperties"/>. </summary>
        /// <param name="resourceName"> The name of the bound resource. </param>
        /// <param name="resourceType"> The standard Azure resource type of the bound resource. </param>
        /// <param name="resourceId"> The Azure resource id of the bound resource. </param>
        /// <param name="key"> The key of the bound resource. </param>
        /// <param name="bindingParameters"> Binding parameters of the Binding resource. </param>
        /// <param name="generatedProperties"> The generated Spring Boot property file for this binding. The secret will be deducted. </param>
        /// <param name="createdOn"> Creation time of the Binding resource. </param>
        /// <param name="updatedOn"> Update time of the Binding resource. </param>
        /// <returns> A new <see cref="Models.AppPlatformBindingProperties"/> instance for mocking. </returns>
        public static AppPlatformBindingProperties AppPlatformBindingProperties(string resourceName = null, string resourceType = null, ResourceIdentifier resourceId = null, string key = null, IDictionary<string, BinaryData> bindingParameters = null, string generatedProperties = null, DateTimeOffset? createdOn = null, DateTimeOffset? updatedOn = null)
        {
            bindingParameters ??= new Dictionary<string, BinaryData>();

            return new AppPlatformBindingProperties(
                resourceName,
                resourceType,
                resourceId,
                key,
                bindingParameters,
                generatedProperties,
                createdOn,
                updatedOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformStorageData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Properties of the storage resource payload.
        /// Please note <see cref="AppPlatformStorageProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AppPlatformStorageAccount"/>.
        /// </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformStorageData"/> instance for mocking. </returns>
        public static AppPlatformStorageData AppPlatformStorageData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AppPlatformStorageProperties properties = null)
        {
            return new AppPlatformStorageData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformCertificateData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Properties of the certificate resource payload.
        /// Please note <see cref="Models.AppPlatformCertificateProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.AppPlatformContentCertificateProperties"/> and <see cref="Models.AppPlatformKeyVaultCertificateProperties"/>.
        /// </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformCertificateData"/> instance for mocking. </returns>
        public static AppPlatformCertificateData AppPlatformCertificateData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AppPlatformCertificateProperties properties = null)
        {
            return new AppPlatformCertificateData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformCertificateProperties"/>. </summary>
        /// <param name="certificatePropertiesType"> The type of the certificate source. </param>
        /// <param name="thumbprint"> The thumbprint of certificate. </param>
        /// <param name="issuer"> The issuer of certificate. </param>
        /// <param name="issuedOn"> The issue date of certificate. </param>
        /// <param name="expireOn"> The expiration date of certificate. </param>
        /// <param name="activateOn"> The activate date of certificate. </param>
        /// <param name="subjectName"> The subject name of certificate. </param>
        /// <param name="dnsNames"> The domain list of certificate. </param>
        /// <param name="provisioningState"> Provisioning state of the Certificate. </param>
        /// <returns> A new <see cref="Models.AppPlatformCertificateProperties"/> instance for mocking. </returns>
        public static AppPlatformCertificateProperties AppPlatformCertificateProperties(string certificatePropertiesType = null, string thumbprint = null, string issuer = null, DateTimeOffset? issuedOn = null, DateTimeOffset? expireOn = null, DateTimeOffset? activateOn = null, string subjectName = null, IEnumerable<string> dnsNames = null, AppPlatformCertificateProvisioningState? provisioningState = null)
        {
            dnsNames ??= new List<string>();

            return new UnknownCertificateProperties(
                certificatePropertiesType,
                thumbprint,
                issuer,
                issuedOn,
                expireOn,
                activateOn,
                subjectName,
                dnsNames?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformNameAvailabilityResult"/>. </summary>
        /// <param name="isNameAvailable"> Indicates whether the name is available. </param>
        /// <param name="reason"> Reason why the name is not available. </param>
        /// <param name="message"> Message why the name is not available. </param>
        /// <returns> A new <see cref="Models.AppPlatformNameAvailabilityResult"/> instance for mocking. </returns>
        public static AppPlatformNameAvailabilityResult AppPlatformNameAvailabilityResult(bool? isNameAvailable = null, string reason = null, string message = null)
        {
            return new AppPlatformNameAvailabilityResult(isNameAvailable, reason, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformCustomDomainData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Properties of the custom domain resource. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformCustomDomainData"/> instance for mocking. </returns>
        public static AppPlatformCustomDomainData AppPlatformCustomDomainData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AppPlatformCustomDomainProperties properties = null)
        {
            return new AppPlatformCustomDomainData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformCustomDomainProperties"/>. </summary>
        /// <param name="thumbprint"> The thumbprint of bound certificate. </param>
        /// <param name="appName"> The app name of domain. </param>
        /// <param name="certName"> The bound certificate name of domain. </param>
        /// <param name="provisioningState"> Provisioning state of the Domain. </param>
        /// <returns> A new <see cref="Models.AppPlatformCustomDomainProperties"/> instance for mocking. </returns>
        public static AppPlatformCustomDomainProperties AppPlatformCustomDomainProperties(string thumbprint = null, string appName = null, string certName = null, AppPlatformCustomDomainProvisioningState? provisioningState = null)
        {
            return new AppPlatformCustomDomainProperties(thumbprint, appName, certName, provisioningState, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformCustomDomainValidateResult"/>. </summary>
        /// <param name="isValid"> Indicates if domain name is valid. </param>
        /// <param name="message"> Message of why domain name is invalid. </param>
        /// <returns> A new <see cref="Models.AppPlatformCustomDomainValidateResult"/> instance for mocking. </returns>
        public static AppPlatformCustomDomainValidateResult AppPlatformCustomDomainValidateResult(bool? isValid = null, string message = null)
        {
            return new AppPlatformCustomDomainValidateResult(isValid, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformDeploymentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Properties of the Deployment resource. </param>
        /// <param name="sku"> Sku of the Deployment resource. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformDeploymentData"/> instance for mocking. </returns>
        public static AppPlatformDeploymentData AppPlatformDeploymentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AppPlatformDeploymentProperties properties = null, AppPlatformSku sku = null)
        {
            return new AppPlatformDeploymentData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                sku,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformDeploymentProperties"/>. </summary>
        /// <param name="source">
        /// Uploaded source information of the deployment.
        /// Please note <see cref="AppPlatformUserSourceInfo"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AppPlatformBuildResultUserSourceInfo"/>, <see cref="AppPlatformCustomContainerUserSourceInfo"/>, <see cref="JarUploadedUserSourceInfo"/>, <see cref="NetCoreZipUploadedUserSourceInfo"/>, <see cref="SourceUploadedUserSourceInfo"/> and <see cref="AppPlatformUploadedUserSourceInfo"/>.
        /// </param>
        /// <param name="deploymentSettings"> Deployment settings of the Deployment. </param>
        /// <param name="provisioningState"> Provisioning state of the Deployment. </param>
        /// <param name="status"> Status of the Deployment. </param>
        /// <param name="isActive"> Indicates whether the Deployment is active. </param>
        /// <param name="instances"> Collection of instances belong to the Deployment. </param>
        /// <returns> A new <see cref="Models.AppPlatformDeploymentProperties"/> instance for mocking. </returns>
        public static AppPlatformDeploymentProperties AppPlatformDeploymentProperties(AppPlatformUserSourceInfo source = null, AppPlatformDeploymentSettings deploymentSettings = null, AppPlatformDeploymentProvisioningState? provisioningState = null, AppPlatformDeploymentStatus? status = null, bool? isActive = null, IEnumerable<AppPlatformDeploymentInstance> instances = null)
        {
            instances ??= new List<AppPlatformDeploymentInstance>();

            return new AppPlatformDeploymentProperties(
                source,
                deploymentSettings,
                provisioningState,
                status,
                isActive,
                instances?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformDeploymentInstance"/>. </summary>
        /// <param name="name"> Name of the deployment instance. </param>
        /// <param name="status"> Status of the deployment instance. </param>
        /// <param name="reason"> Failed reason of the deployment instance. </param>
        /// <param name="discoveryStatus"> Discovery status of the deployment instance. </param>
        /// <param name="startedOn"> Start time of the deployment instance. </param>
        /// <param name="zone"> Availability zone information of the deployment instance. </param>
        /// <returns> A new <see cref="Models.AppPlatformDeploymentInstance"/> instance for mocking. </returns>
        public static AppPlatformDeploymentInstance AppPlatformDeploymentInstance(string name = null, string status = null, string reason = null, string discoveryStatus = null, DateTimeOffset? startedOn = null, string zone = null)
        {
            return new AppPlatformDeploymentInstance(
                name,
                status,
                reason,
                discoveryStatus,
                startedOn,
                zone,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplicationRemoteDebuggingConfig"/>. </summary>
        /// <param name="port"> Application debugging port. </param>
        /// <param name="isEnabled"> Indicate if remote debugging is enabled. </param>
        /// <returns> A new <see cref="Models.ApplicationRemoteDebuggingConfig"/> instance for mocking. </returns>
        public static ApplicationRemoteDebuggingConfig ApplicationRemoteDebuggingConfig(int? port = null, bool? isEnabled = null)
        {
            return new ApplicationRemoteDebuggingConfig(port, isEnabled, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformLogFileUriResult"/>. </summary>
        /// <param name="uri"> URL of the log file. </param>
        /// <returns> A new <see cref="Models.AppPlatformLogFileUriResult"/> instance for mocking. </returns>
        public static AppPlatformLogFileUriResult AppPlatformLogFileUriResult(Uri uri = null)
        {
            return new AppPlatformLogFileUriResult(uri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformSupportedRuntimeVersion"/>. </summary>
        /// <param name="value"> The raw value which could be passed to deployment CRUD operations. </param>
        /// <param name="platform"> The platform of this runtime version (possible values: "Java" or ".NET"). </param>
        /// <param name="version"> The detailed version (major.minor) of the platform. </param>
        /// <returns> A new <see cref="Models.AppPlatformSupportedRuntimeVersion"/> instance for mocking. </returns>
        public static AppPlatformSupportedRuntimeVersion AppPlatformSupportedRuntimeVersion(AppPlatformSupportedRuntimeValue? value = null, AppPlatformSupportedRuntimePlatform? platform = null, string version = null)
        {
            return new AppPlatformSupportedRuntimeVersion(value, platform, version, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AvailableAppPlatformSku"/>. </summary>
        /// <param name="resourceType"> Gets the type of resource the SKU applies to. </param>
        /// <param name="name"> Gets the name of SKU. </param>
        /// <param name="tier"> Gets the tier of SKU. </param>
        /// <param name="capacity"> Gets the capacity of SKU. </param>
        /// <param name="locations"> Gets the set of locations that the SKU is available. </param>
        /// <param name="locationInfo"> Gets a list of locations and availability zones in those locations where the SKU is available. </param>
        /// <param name="restrictions">
        /// Gets the restrictions because of which SKU cannot be used. This is
        /// empty if there are no restrictions.
        /// </param>
        /// <returns> A new <see cref="Models.AvailableAppPlatformSku"/> instance for mocking. </returns>
        public static AvailableAppPlatformSku AvailableAppPlatformSku(ResourceType? resourceType = null, string name = null, string tier = null, AppPlatformSkuCapacity capacity = null, IEnumerable<AzureLocation> locations = null, IEnumerable<AppPlatformSkuLocationInfo> locationInfo = null, IEnumerable<AppPlatformSkuRestrictions> restrictions = null)
        {
            locations ??= new List<AzureLocation>();
            locationInfo ??= new List<AppPlatformSkuLocationInfo>();
            restrictions ??= new List<AppPlatformSkuRestrictions>();

            return new AvailableAppPlatformSku(
                resourceType,
                name,
                tier,
                capacity,
                locations?.ToList(),
                locationInfo?.ToList(),
                restrictions?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformSkuCapacity"/>. </summary>
        /// <param name="minimum"> Gets or sets the minimum. </param>
        /// <param name="maximum"> Gets or sets the maximum. </param>
        /// <param name="default"> Gets or sets the default. </param>
        /// <param name="scaleType"> Gets or sets the type of the scale. </param>
        /// <returns> A new <see cref="Models.AppPlatformSkuCapacity"/> instance for mocking. </returns>
        public static AppPlatformSkuCapacity AppPlatformSkuCapacity(int minimum = default, int? maximum = null, int? @default = null, AppPlatformSkuScaleType? scaleType = null)
        {
            return new AppPlatformSkuCapacity(minimum, maximum, @default, scaleType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformSkuLocationInfo"/>. </summary>
        /// <param name="location"> Gets location of the SKU. </param>
        /// <param name="zones"> Gets list of availability zones where the SKU is supported. </param>
        /// <param name="zoneDetails"> Gets details of capabilities available to a SKU in specific zones. </param>
        /// <returns> A new <see cref="Models.AppPlatformSkuLocationInfo"/> instance for mocking. </returns>
        public static AppPlatformSkuLocationInfo AppPlatformSkuLocationInfo(AzureLocation? location = null, IEnumerable<string> zones = null, IEnumerable<AppPlatformSkuZoneDetails> zoneDetails = null)
        {
            zones ??= new List<string>();
            zoneDetails ??= new List<AppPlatformSkuZoneDetails>();

            return new AppPlatformSkuLocationInfo(location, zones?.ToList(), zoneDetails?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformSkuZoneDetails"/>. </summary>
        /// <param name="name">
        /// Gets the set of zones that the SKU is available in with the
        /// specified capabilities.
        /// </param>
        /// <param name="capabilities">
        /// Gets a list of capabilities that are available for the SKU in the
        /// specified list of zones.
        /// </param>
        /// <returns> A new <see cref="Models.AppPlatformSkuZoneDetails"/> instance for mocking. </returns>
        public static AppPlatformSkuZoneDetails AppPlatformSkuZoneDetails(IEnumerable<string> name = null, IEnumerable<AppPlatformSkuCapabilities> capabilities = null)
        {
            name ??= new List<string>();
            capabilities ??= new List<AppPlatformSkuCapabilities>();

            return new AppPlatformSkuZoneDetails(name?.ToList(), capabilities?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformSkuCapabilities"/>. </summary>
        /// <param name="name"> Gets an invariant to describe the feature. </param>
        /// <param name="value"> Gets an invariant if the feature is measured by quantity. </param>
        /// <returns> A new <see cref="Models.AppPlatformSkuCapabilities"/> instance for mocking. </returns>
        public static AppPlatformSkuCapabilities AppPlatformSkuCapabilities(string name = null, string value = null)
        {
            return new AppPlatformSkuCapabilities(name, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformSkuRestrictions"/>. </summary>
        /// <param name="restrictionsType"> Gets the type of restrictions. Possible values include: 'Location', 'Zone'. </param>
        /// <param name="values">
        /// Gets the value of restrictions. If the restriction type is set to
        /// location. This would be different locations where the SKU is restricted.
        /// </param>
        /// <param name="restrictionInfo"> Gets the information about the restriction where the SKU cannot be used. </param>
        /// <param name="reasonCode"> Gets the reason for restriction. Possible values include: 'QuotaId', 'NotAvailableForSubscription'. </param>
        /// <returns> A new <see cref="Models.AppPlatformSkuRestrictions"/> instance for mocking. </returns>
        public static AppPlatformSkuRestrictions AppPlatformSkuRestrictions(AppPlatformSkuRestrictionsType? restrictionsType = null, IEnumerable<string> values = null, AppPlatformSkuRestrictionInfo restrictionInfo = null, AppPlatformSkuRestrictionsReasonCode? reasonCode = null)
        {
            values ??= new List<string>();

            return new AppPlatformSkuRestrictions(restrictionsType, values?.ToList(), restrictionInfo, reasonCode, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformSkuRestrictionInfo"/>. </summary>
        /// <param name="locations"> Gets locations where the SKU is restricted. </param>
        /// <param name="zones"> Gets list of availability zones where the SKU is restricted. </param>
        /// <returns> A new <see cref="Models.AppPlatformSkuRestrictionInfo"/> instance for mocking. </returns>
        public static AppPlatformSkuRestrictionInfo AppPlatformSkuRestrictionInfo(IEnumerable<AzureLocation> locations = null, IEnumerable<string> zones = null)
        {
            locations ??= new List<AzureLocation>();
            zones ??= new List<string>();

            return new AppPlatformSkuRestrictionInfo(locations?.ToList(), zones?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformGatewayData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Spring Cloud Gateway properties payload. </param>
        /// <param name="sku"> Sku of the Spring Cloud Gateway resource. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformGatewayData"/> instance for mocking. </returns>
        public static AppPlatformGatewayData AppPlatformGatewayData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AppPlatformGatewayProperties properties = null, AppPlatformSku sku = null)
        {
            return new AppPlatformGatewayData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                sku,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformGatewayProperties"/>. </summary>
        /// <param name="provisioningState"> State of the Spring Cloud Gateway. </param>
        /// <param name="isPublic"> Indicates whether the Spring Cloud Gateway exposes endpoint. </param>
        /// <param name="uri"> URL of the Spring Cloud Gateway, exposed when 'public' is true. </param>
        /// <param name="isHttpsOnly"> Indicate if only https is allowed. </param>
        /// <param name="ssoProperties"> Single sign-on related configuration. </param>
        /// <param name="apiMetadataProperties"> API metadata property for Spring Cloud Gateway. </param>
        /// <param name="corsProperties"> Cross-Origin Resource Sharing property. </param>
        /// <param name="resourceRequests"> The requested resource quantity for required CPU and Memory. </param>
        /// <param name="instances"> Collection of instances belong to Spring Cloud Gateway. </param>
        /// <param name="operatorProperties"> Properties of the Spring Cloud Gateway Operator. </param>
        /// <returns> A new <see cref="Models.AppPlatformGatewayProperties"/> instance for mocking. </returns>
        public static AppPlatformGatewayProperties AppPlatformGatewayProperties(AppPlatformGatewayProvisioningState? provisioningState = null, bool? isPublic = null, Uri uri = null, bool? isHttpsOnly = null, AppPlatformSsoProperties ssoProperties = null, AppPlatformGatewayApiMetadataProperties apiMetadataProperties = null, AppPlatformGatewayCorsProperties corsProperties = null, AppPlatformGatewayResourceRequirements resourceRequests = null, IEnumerable<AppPlatformGatewayInstance> instances = null, AppPlatformGatewayOperatorProperties operatorProperties = null)
        {
            instances ??= new List<AppPlatformGatewayInstance>();

            return new AppPlatformGatewayProperties(
                provisioningState,
                isPublic,
                uri,
                isHttpsOnly,
                ssoProperties,
                apiMetadataProperties,
                corsProperties,
                resourceRequests,
                instances?.ToList(),
                operatorProperties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformGatewayInstance"/>. </summary>
        /// <param name="name"> Name of the Spring Cloud Gateway instance. </param>
        /// <param name="status"> Status of the Spring Cloud Gateway instance. </param>
        /// <returns> A new <see cref="Models.AppPlatformGatewayInstance"/> instance for mocking. </returns>
        public static AppPlatformGatewayInstance AppPlatformGatewayInstance(string name = null, string status = null)
        {
            return new AppPlatformGatewayInstance(name, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformGatewayOperatorProperties"/>. </summary>
        /// <param name="resourceRequests"> The requested resource quantity for required CPU and Memory. </param>
        /// <param name="instances"> Collection of instances belong to Spring Cloud Gateway operator. </param>
        /// <returns> A new <see cref="Models.AppPlatformGatewayOperatorProperties"/> instance for mocking. </returns>
        public static AppPlatformGatewayOperatorProperties AppPlatformGatewayOperatorProperties(AppPlatformGatewayOperatorResourceRequirements resourceRequests = null, IEnumerable<AppPlatformGatewayInstance> instances = null)
        {
            instances ??= new List<AppPlatformGatewayInstance>();

            return new AppPlatformGatewayOperatorProperties(resourceRequests, instances?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformGatewayOperatorResourceRequirements"/>. </summary>
        /// <param name="cpu"> Cpu allocated to each Spring Cloud Gateway Operator instance. </param>
        /// <param name="memory"> Memory allocated to each Spring Cloud Gateway Operator instance. </param>
        /// <param name="instanceCount"> Instance count of the Spring Cloud Gateway Operator. </param>
        /// <returns> A new <see cref="Models.AppPlatformGatewayOperatorResourceRequirements"/> instance for mocking. </returns>
        public static AppPlatformGatewayOperatorResourceRequirements AppPlatformGatewayOperatorResourceRequirements(string cpu = null, string memory = null, int? instanceCount = null)
        {
            return new AppPlatformGatewayOperatorResourceRequirements(cpu, memory, instanceCount, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformGatewayRouteConfigData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> API route config of the Spring Cloud Gateway. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformGatewayRouteConfigData"/> instance for mocking. </returns>
        public static AppPlatformGatewayRouteConfigData AppPlatformGatewayRouteConfigData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AppPlatformGatewayRouteConfigProperties properties = null)
        {
            return new AppPlatformGatewayRouteConfigData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformGatewayRouteConfigProperties"/>. </summary>
        /// <param name="provisioningState"> State of the Spring Cloud Gateway route config. </param>
        /// <param name="appResourceId"> The resource Id of the Azure Spring Apps app, required unless route defines `uri`. </param>
        /// <param name="openApiUri"> OpenAPI properties of Spring Cloud Gateway route config. </param>
        /// <param name="protocol"> Protocol of routed Azure Spring Apps applications. </param>
        /// <param name="routes"> Array of API routes, each route contains properties such as `title`, `uri`, `ssoEnabled`, `predicates`, `filters`. </param>
        /// <returns> A new <see cref="Models.AppPlatformGatewayRouteConfigProperties"/> instance for mocking. </returns>
        public static AppPlatformGatewayRouteConfigProperties AppPlatformGatewayRouteConfigProperties(AppPlatformGatewayProvisioningState? provisioningState = null, ResourceIdentifier appResourceId = null, Uri openApiUri = null, AppPlatformGatewayRouteConfigProtocol? protocol = null, IEnumerable<AppPlatformGatewayApiRoute> routes = null)
        {
            routes ??= new List<AppPlatformGatewayApiRoute>();

            return new AppPlatformGatewayRouteConfigProperties(
                provisioningState,
                appResourceId,
                openApiUri != null ? new GatewayRouteConfigOpenApiProperties(openApiUri, serializedAdditionalRawData: null) : null,
                protocol,
                routes?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformGatewayCustomDomainData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="gatewayCustomDomainThumbprint"> The properties of custom domain for Spring Cloud Gateway. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformGatewayCustomDomainData"/> instance for mocking. </returns>
        public static AppPlatformGatewayCustomDomainData AppPlatformGatewayCustomDomainData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string gatewayCustomDomainThumbprint = null)
        {
            return new AppPlatformGatewayCustomDomainData(
                id,
                name,
                resourceType,
                systemData,
                gatewayCustomDomainThumbprint != null ? new GatewayCustomDomainProperties(gatewayCustomDomainThumbprint, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformApiPortalData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> API portal properties payload. </param>
        /// <param name="sku"> Sku of the API portal resource. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformApiPortalData"/> instance for mocking. </returns>
        public static AppPlatformApiPortalData AppPlatformApiPortalData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AppPlatformApiPortalProperties properties = null, AppPlatformSku sku = null)
        {
            return new AppPlatformApiPortalData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                sku,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformApiPortalProperties"/>. </summary>
        /// <param name="provisioningState"> State of the API portal. </param>
        /// <param name="isPublic"> Indicates whether the API portal exposes endpoint. </param>
        /// <param name="uri"> URL of the API portal, exposed when 'public' is true. </param>
        /// <param name="isHttpsOnly"> Indicate if only https is allowed. </param>
        /// <param name="gatewayIds"> The array of resource Ids of gateway to integrate with API portal. </param>
        /// <param name="sourceUris"> Collection of OpenAPI source URL locations. </param>
        /// <param name="ssoProperties"> Single sign-on related configuration. </param>
        /// <param name="resourceRequests"> The requested resource quantity for required CPU and Memory. </param>
        /// <param name="instances"> Collection of instances belong to API portal. </param>
        /// <returns> A new <see cref="Models.AppPlatformApiPortalProperties"/> instance for mocking. </returns>
        public static AppPlatformApiPortalProperties AppPlatformApiPortalProperties(AppPlatformApiPortalProvisioningState? provisioningState = null, bool? isPublic = null, Uri uri = null, bool? isHttpsOnly = null, IEnumerable<ResourceIdentifier> gatewayIds = null, IEnumerable<Uri> sourceUris = null, AppPlatformSsoProperties ssoProperties = null, AppPlatformApiPortalResourceRequirements resourceRequests = null, IEnumerable<AppPlatformApiPortalInstance> instances = null)
        {
            gatewayIds ??= new List<ResourceIdentifier>();
            sourceUris ??= new List<Uri>();
            instances ??= new List<AppPlatformApiPortalInstance>();

            return new AppPlatformApiPortalProperties(
                provisioningState,
                isPublic,
                uri,
                isHttpsOnly,
                gatewayIds?.ToList(),
                sourceUris?.ToList(),
                ssoProperties,
                resourceRequests,
                instances?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformApiPortalResourceRequirements"/>. </summary>
        /// <param name="cpu"> Cpu allocated to each API portal instance. </param>
        /// <param name="memory"> Memory allocated to each API portal instance. </param>
        /// <returns> A new <see cref="Models.AppPlatformApiPortalResourceRequirements"/> instance for mocking. </returns>
        public static AppPlatformApiPortalResourceRequirements AppPlatformApiPortalResourceRequirements(string cpu = null, string memory = null)
        {
            return new AppPlatformApiPortalResourceRequirements(cpu, memory, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformApiPortalInstance"/>. </summary>
        /// <param name="name"> Name of the API portal instance. </param>
        /// <param name="status"> Status of the API portal instance. </param>
        /// <returns> A new <see cref="Models.AppPlatformApiPortalInstance"/> instance for mocking. </returns>
        public static AppPlatformApiPortalInstance AppPlatformApiPortalInstance(string name = null, string status = null)
        {
            return new AppPlatformApiPortalInstance(name, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="AppPlatform.AppPlatformApiPortalCustomDomainData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="apiPortalCustomDomainThumbprint"> The properties of custom domain for API portal. </param>
        /// <returns> A new <see cref="AppPlatform.AppPlatformApiPortalCustomDomainData"/> instance for mocking. </returns>
        public static AppPlatformApiPortalCustomDomainData AppPlatformApiPortalCustomDomainData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string apiPortalCustomDomainThumbprint = null)
        {
            return new AppPlatformApiPortalCustomDomainData(
                id,
                name,
                resourceType,
                systemData,
                apiPortalCustomDomainThumbprint != null ? new ApiPortalCustomDomainProperties(apiPortalCustomDomainThumbprint, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformKeyVaultCertificateProperties"/>. </summary>
        /// <param name="thumbprint"> The thumbprint of certificate. </param>
        /// <param name="issuer"> The issuer of certificate. </param>
        /// <param name="issuedOn"> The issue date of certificate. </param>
        /// <param name="expireOn"> The expiration date of certificate. </param>
        /// <param name="activateOn"> The activate date of certificate. </param>
        /// <param name="subjectName"> The subject name of certificate. </param>
        /// <param name="dnsNames"> The domain list of certificate. </param>
        /// <param name="provisioningState"> Provisioning state of the Certificate. </param>
        /// <param name="vaultUri"> The vault uri of user key vault. </param>
        /// <param name="keyVaultCertName"> The certificate name of key vault. </param>
        /// <param name="certVersion"> The certificate version of key vault. </param>
        /// <param name="isPrivateKeyExcluded"> Optional. If set to true, it will not import private key from key vault. </param>
        /// <returns> A new <see cref="Models.AppPlatformKeyVaultCertificateProperties"/> instance for mocking. </returns>
        public static AppPlatformKeyVaultCertificateProperties AppPlatformKeyVaultCertificateProperties(string thumbprint = null, string issuer = null, DateTimeOffset? issuedOn = null, DateTimeOffset? expireOn = null, DateTimeOffset? activateOn = null, string subjectName = null, IEnumerable<string> dnsNames = null, AppPlatformCertificateProvisioningState? provisioningState = null, Uri vaultUri = null, string keyVaultCertName = null, string certVersion = null, bool? isPrivateKeyExcluded = null)
        {
            dnsNames ??= new List<string>();

            return new AppPlatformKeyVaultCertificateProperties(
                "KeyVaultCertificate",
                thumbprint,
                issuer,
                issuedOn,
                expireOn,
                activateOn,
                subjectName,
                dnsNames?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null,
                vaultUri,
                keyVaultCertName,
                certVersion,
                isPrivateKeyExcluded);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AppPlatformContentCertificateProperties"/>. </summary>
        /// <param name="thumbprint"> The thumbprint of certificate. </param>
        /// <param name="issuer"> The issuer of certificate. </param>
        /// <param name="issuedOn"> The issue date of certificate. </param>
        /// <param name="expireOn"> The expiration date of certificate. </param>
        /// <param name="activateOn"> The activate date of certificate. </param>
        /// <param name="subjectName"> The subject name of certificate. </param>
        /// <param name="dnsNames"> The domain list of certificate. </param>
        /// <param name="provisioningState"> Provisioning state of the Certificate. </param>
        /// <param name="content"> The content of uploaded certificate. </param>
        /// <returns> A new <see cref="Models.AppPlatformContentCertificateProperties"/> instance for mocking. </returns>
        public static AppPlatformContentCertificateProperties AppPlatformContentCertificateProperties(string thumbprint = null, string issuer = null, DateTimeOffset? issuedOn = null, DateTimeOffset? expireOn = null, DateTimeOffset? activateOn = null, string subjectName = null, IEnumerable<string> dnsNames = null, AppPlatformCertificateProvisioningState? provisioningState = null, string content = null)
        {
            dnsNames ??= new List<string>();

            return new AppPlatformContentCertificateProperties(
                "ContentCertificate",
                thumbprint,
                issuer,
                issuedOn,
                expireOn,
                activateOn,
                subjectName,
                dnsNames?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null,
                content);
        }
    }
}
