// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.AppPlatform
{
    /// <summary>
    /// A class representing a collection of <see cref="AppPlatformGatewayRouteConfigResource"/> and their operations.
    /// Each <see cref="AppPlatformGatewayRouteConfigResource"/> in the collection will belong to the same instance of <see cref="AppPlatformGatewayResource"/>.
    /// To get an <see cref="AppPlatformGatewayRouteConfigCollection"/> instance call the GetAppPlatformGatewayRouteConfigs method from an instance of <see cref="AppPlatformGatewayResource"/>.
    /// </summary>
    public partial class AppPlatformGatewayRouteConfigCollection : ArmCollection, IEnumerable<AppPlatformGatewayRouteConfigResource>, IAsyncEnumerable<AppPlatformGatewayRouteConfigResource>
    {
        private readonly ClientDiagnostics _appPlatformGatewayRouteConfigGatewayRouteConfigsClientDiagnostics;
        private readonly GatewayRouteConfigsRestOperations _appPlatformGatewayRouteConfigGatewayRouteConfigsRestClient;

        /// <summary> Initializes a new instance of the <see cref="AppPlatformGatewayRouteConfigCollection"/> class for mocking. </summary>
        protected AppPlatformGatewayRouteConfigCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="AppPlatformGatewayRouteConfigCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal AppPlatformGatewayRouteConfigCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _appPlatformGatewayRouteConfigGatewayRouteConfigsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.AppPlatform", AppPlatformGatewayRouteConfigResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(AppPlatformGatewayRouteConfigResource.ResourceType, out string appPlatformGatewayRouteConfigGatewayRouteConfigsApiVersion);
            _appPlatformGatewayRouteConfigGatewayRouteConfigsRestClient = new GatewayRouteConfigsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, appPlatformGatewayRouteConfigGatewayRouteConfigsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != AppPlatformGatewayResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, AppPlatformGatewayResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create the default Spring Cloud Gateway route configs or update the existing Spring Cloud Gateway route configs.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/gateways/{gatewayName}/routeConfigs/{routeConfigName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GatewayRouteConfigs_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformGatewayRouteConfigResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="routeConfigName"> The name of the Spring Cloud Gateway route config. </param>
        /// <param name="data"> The Spring Cloud Gateway route config for the create or update operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="routeConfigName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="routeConfigName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<AppPlatformGatewayRouteConfigResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string routeConfigName, AppPlatformGatewayRouteConfigData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(routeConfigName, nameof(routeConfigName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _appPlatformGatewayRouteConfigGatewayRouteConfigsClientDiagnostics.CreateScope("AppPlatformGatewayRouteConfigCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _appPlatformGatewayRouteConfigGatewayRouteConfigsRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, routeConfigName, data, cancellationToken).ConfigureAwait(false);
                var operation = new AppPlatformArmOperation<AppPlatformGatewayRouteConfigResource>(new AppPlatformGatewayRouteConfigOperationSource(Client), _appPlatformGatewayRouteConfigGatewayRouteConfigsClientDiagnostics, Pipeline, _appPlatformGatewayRouteConfigGatewayRouteConfigsRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, routeConfigName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create the default Spring Cloud Gateway route configs or update the existing Spring Cloud Gateway route configs.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/gateways/{gatewayName}/routeConfigs/{routeConfigName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GatewayRouteConfigs_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformGatewayRouteConfigResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="routeConfigName"> The name of the Spring Cloud Gateway route config. </param>
        /// <param name="data"> The Spring Cloud Gateway route config for the create or update operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="routeConfigName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="routeConfigName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<AppPlatformGatewayRouteConfigResource> CreateOrUpdate(WaitUntil waitUntil, string routeConfigName, AppPlatformGatewayRouteConfigData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(routeConfigName, nameof(routeConfigName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _appPlatformGatewayRouteConfigGatewayRouteConfigsClientDiagnostics.CreateScope("AppPlatformGatewayRouteConfigCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _appPlatformGatewayRouteConfigGatewayRouteConfigsRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, routeConfigName, data, cancellationToken);
                var operation = new AppPlatformArmOperation<AppPlatformGatewayRouteConfigResource>(new AppPlatformGatewayRouteConfigOperationSource(Client), _appPlatformGatewayRouteConfigGatewayRouteConfigsClientDiagnostics, Pipeline, _appPlatformGatewayRouteConfigGatewayRouteConfigsRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, routeConfigName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the Spring Cloud Gateway route configs.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/gateways/{gatewayName}/routeConfigs/{routeConfigName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GatewayRouteConfigs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformGatewayRouteConfigResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="routeConfigName"> The name of the Spring Cloud Gateway route config. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="routeConfigName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="routeConfigName"/> is null. </exception>
        public virtual async Task<Response<AppPlatformGatewayRouteConfigResource>> GetAsync(string routeConfigName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(routeConfigName, nameof(routeConfigName));

            using var scope = _appPlatformGatewayRouteConfigGatewayRouteConfigsClientDiagnostics.CreateScope("AppPlatformGatewayRouteConfigCollection.Get");
            scope.Start();
            try
            {
                var response = await _appPlatformGatewayRouteConfigGatewayRouteConfigsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, routeConfigName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AppPlatformGatewayRouteConfigResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the Spring Cloud Gateway route configs.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/gateways/{gatewayName}/routeConfigs/{routeConfigName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GatewayRouteConfigs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformGatewayRouteConfigResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="routeConfigName"> The name of the Spring Cloud Gateway route config. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="routeConfigName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="routeConfigName"/> is null. </exception>
        public virtual Response<AppPlatformGatewayRouteConfigResource> Get(string routeConfigName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(routeConfigName, nameof(routeConfigName));

            using var scope = _appPlatformGatewayRouteConfigGatewayRouteConfigsClientDiagnostics.CreateScope("AppPlatformGatewayRouteConfigCollection.Get");
            scope.Start();
            try
            {
                var response = _appPlatformGatewayRouteConfigGatewayRouteConfigsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, routeConfigName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AppPlatformGatewayRouteConfigResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Handle requests to list all Spring Cloud Gateway route configs.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/gateways/{gatewayName}/routeConfigs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GatewayRouteConfigs_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformGatewayRouteConfigResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="AppPlatformGatewayRouteConfigResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<AppPlatformGatewayRouteConfigResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _appPlatformGatewayRouteConfigGatewayRouteConfigsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _appPlatformGatewayRouteConfigGatewayRouteConfigsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new AppPlatformGatewayRouteConfigResource(Client, AppPlatformGatewayRouteConfigData.DeserializeAppPlatformGatewayRouteConfigData(e)), _appPlatformGatewayRouteConfigGatewayRouteConfigsClientDiagnostics, Pipeline, "AppPlatformGatewayRouteConfigCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Handle requests to list all Spring Cloud Gateway route configs.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/gateways/{gatewayName}/routeConfigs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GatewayRouteConfigs_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformGatewayRouteConfigResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="AppPlatformGatewayRouteConfigResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<AppPlatformGatewayRouteConfigResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _appPlatformGatewayRouteConfigGatewayRouteConfigsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _appPlatformGatewayRouteConfigGatewayRouteConfigsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new AppPlatformGatewayRouteConfigResource(Client, AppPlatformGatewayRouteConfigData.DeserializeAppPlatformGatewayRouteConfigData(e)), _appPlatformGatewayRouteConfigGatewayRouteConfigsClientDiagnostics, Pipeline, "AppPlatformGatewayRouteConfigCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/gateways/{gatewayName}/routeConfigs/{routeConfigName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GatewayRouteConfigs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformGatewayRouteConfigResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="routeConfigName"> The name of the Spring Cloud Gateway route config. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="routeConfigName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="routeConfigName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string routeConfigName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(routeConfigName, nameof(routeConfigName));

            using var scope = _appPlatformGatewayRouteConfigGatewayRouteConfigsClientDiagnostics.CreateScope("AppPlatformGatewayRouteConfigCollection.Exists");
            scope.Start();
            try
            {
                var response = await _appPlatformGatewayRouteConfigGatewayRouteConfigsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, routeConfigName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/gateways/{gatewayName}/routeConfigs/{routeConfigName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GatewayRouteConfigs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformGatewayRouteConfigResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="routeConfigName"> The name of the Spring Cloud Gateway route config. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="routeConfigName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="routeConfigName"/> is null. </exception>
        public virtual Response<bool> Exists(string routeConfigName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(routeConfigName, nameof(routeConfigName));

            using var scope = _appPlatformGatewayRouteConfigGatewayRouteConfigsClientDiagnostics.CreateScope("AppPlatformGatewayRouteConfigCollection.Exists");
            scope.Start();
            try
            {
                var response = _appPlatformGatewayRouteConfigGatewayRouteConfigsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, routeConfigName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/gateways/{gatewayName}/routeConfigs/{routeConfigName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GatewayRouteConfigs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformGatewayRouteConfigResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="routeConfigName"> The name of the Spring Cloud Gateway route config. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="routeConfigName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="routeConfigName"/> is null. </exception>
        public virtual async Task<NullableResponse<AppPlatformGatewayRouteConfigResource>> GetIfExistsAsync(string routeConfigName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(routeConfigName, nameof(routeConfigName));

            using var scope = _appPlatformGatewayRouteConfigGatewayRouteConfigsClientDiagnostics.CreateScope("AppPlatformGatewayRouteConfigCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _appPlatformGatewayRouteConfigGatewayRouteConfigsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, routeConfigName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<AppPlatformGatewayRouteConfigResource>(response.GetRawResponse());
                return Response.FromValue(new AppPlatformGatewayRouteConfigResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/gateways/{gatewayName}/routeConfigs/{routeConfigName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GatewayRouteConfigs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformGatewayRouteConfigResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="routeConfigName"> The name of the Spring Cloud Gateway route config. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="routeConfigName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="routeConfigName"/> is null. </exception>
        public virtual NullableResponse<AppPlatformGatewayRouteConfigResource> GetIfExists(string routeConfigName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(routeConfigName, nameof(routeConfigName));

            using var scope = _appPlatformGatewayRouteConfigGatewayRouteConfigsClientDiagnostics.CreateScope("AppPlatformGatewayRouteConfigCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _appPlatformGatewayRouteConfigGatewayRouteConfigsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, routeConfigName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<AppPlatformGatewayRouteConfigResource>(response.GetRawResponse());
                return Response.FromValue(new AppPlatformGatewayRouteConfigResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<AppPlatformGatewayRouteConfigResource> IEnumerable<AppPlatformGatewayRouteConfigResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<AppPlatformGatewayRouteConfigResource> IAsyncEnumerable<AppPlatformGatewayRouteConfigResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
