// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.AppPlatform
{
    /// <summary>
    /// A class representing a collection of <see cref="AppPlatformConfigurationServiceResource"/> and their operations.
    /// Each <see cref="AppPlatformConfigurationServiceResource"/> in the collection will belong to the same instance of <see cref="AppPlatformServiceResource"/>.
    /// To get an <see cref="AppPlatformConfigurationServiceCollection"/> instance call the GetAppPlatformConfigurationServices method from an instance of <see cref="AppPlatformServiceResource"/>.
    /// </summary>
    public partial class AppPlatformConfigurationServiceCollection : ArmCollection, IEnumerable<AppPlatformConfigurationServiceResource>, IAsyncEnumerable<AppPlatformConfigurationServiceResource>
    {
        private readonly ClientDiagnostics _appPlatformConfigurationServiceConfigurationServicesClientDiagnostics;
        private readonly ConfigurationServicesRestOperations _appPlatformConfigurationServiceConfigurationServicesRestClient;

        /// <summary> Initializes a new instance of the <see cref="AppPlatformConfigurationServiceCollection"/> class for mocking. </summary>
        protected AppPlatformConfigurationServiceCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="AppPlatformConfigurationServiceCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal AppPlatformConfigurationServiceCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _appPlatformConfigurationServiceConfigurationServicesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.AppPlatform", AppPlatformConfigurationServiceResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(AppPlatformConfigurationServiceResource.ResourceType, out string appPlatformConfigurationServiceConfigurationServicesApiVersion);
            _appPlatformConfigurationServiceConfigurationServicesRestClient = new ConfigurationServicesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, appPlatformConfigurationServiceConfigurationServicesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != AppPlatformServiceResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, AppPlatformServiceResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create the default Application Configuration Service or update the existing Application Configuration Service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configurationServices/{configurationServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationServices_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformConfigurationServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="configurationServiceName"> The name of Application Configuration Service. </param>
        /// <param name="data"> Parameters for the update operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationServiceName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<AppPlatformConfigurationServiceResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string configurationServiceName, AppPlatformConfigurationServiceData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationServiceName, nameof(configurationServiceName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _appPlatformConfigurationServiceConfigurationServicesClientDiagnostics.CreateScope("AppPlatformConfigurationServiceCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _appPlatformConfigurationServiceConfigurationServicesRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationServiceName, data, cancellationToken).ConfigureAwait(false);
                var operation = new AppPlatformArmOperation<AppPlatformConfigurationServiceResource>(new AppPlatformConfigurationServiceOperationSource(Client), _appPlatformConfigurationServiceConfigurationServicesClientDiagnostics, Pipeline, _appPlatformConfigurationServiceConfigurationServicesRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationServiceName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create the default Application Configuration Service or update the existing Application Configuration Service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configurationServices/{configurationServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationServices_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformConfigurationServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="configurationServiceName"> The name of Application Configuration Service. </param>
        /// <param name="data"> Parameters for the update operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationServiceName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<AppPlatformConfigurationServiceResource> CreateOrUpdate(WaitUntil waitUntil, string configurationServiceName, AppPlatformConfigurationServiceData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationServiceName, nameof(configurationServiceName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _appPlatformConfigurationServiceConfigurationServicesClientDiagnostics.CreateScope("AppPlatformConfigurationServiceCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _appPlatformConfigurationServiceConfigurationServicesRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationServiceName, data, cancellationToken);
                var operation = new AppPlatformArmOperation<AppPlatformConfigurationServiceResource>(new AppPlatformConfigurationServiceOperationSource(Client), _appPlatformConfigurationServiceConfigurationServicesClientDiagnostics, Pipeline, _appPlatformConfigurationServiceConfigurationServicesRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationServiceName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the Application Configuration Service and its properties.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configurationServices/{configurationServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationServices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformConfigurationServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationServiceName"> The name of Application Configuration Service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationServiceName"/> is null. </exception>
        public virtual async Task<Response<AppPlatformConfigurationServiceResource>> GetAsync(string configurationServiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationServiceName, nameof(configurationServiceName));

            using var scope = _appPlatformConfigurationServiceConfigurationServicesClientDiagnostics.CreateScope("AppPlatformConfigurationServiceCollection.Get");
            scope.Start();
            try
            {
                var response = await _appPlatformConfigurationServiceConfigurationServicesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationServiceName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AppPlatformConfigurationServiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the Application Configuration Service and its properties.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configurationServices/{configurationServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationServices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformConfigurationServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationServiceName"> The name of Application Configuration Service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationServiceName"/> is null. </exception>
        public virtual Response<AppPlatformConfigurationServiceResource> Get(string configurationServiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationServiceName, nameof(configurationServiceName));

            using var scope = _appPlatformConfigurationServiceConfigurationServicesClientDiagnostics.CreateScope("AppPlatformConfigurationServiceCollection.Get");
            scope.Start();
            try
            {
                var response = _appPlatformConfigurationServiceConfigurationServicesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationServiceName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AppPlatformConfigurationServiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Handles requests to list all resources in a Service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configurationServices</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationServices_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformConfigurationServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="AppPlatformConfigurationServiceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<AppPlatformConfigurationServiceResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _appPlatformConfigurationServiceConfigurationServicesRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _appPlatformConfigurationServiceConfigurationServicesRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new AppPlatformConfigurationServiceResource(Client, AppPlatformConfigurationServiceData.DeserializeAppPlatformConfigurationServiceData(e)), _appPlatformConfigurationServiceConfigurationServicesClientDiagnostics, Pipeline, "AppPlatformConfigurationServiceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Handles requests to list all resources in a Service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configurationServices</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationServices_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformConfigurationServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="AppPlatformConfigurationServiceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<AppPlatformConfigurationServiceResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _appPlatformConfigurationServiceConfigurationServicesRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _appPlatformConfigurationServiceConfigurationServicesRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new AppPlatformConfigurationServiceResource(Client, AppPlatformConfigurationServiceData.DeserializeAppPlatformConfigurationServiceData(e)), _appPlatformConfigurationServiceConfigurationServicesClientDiagnostics, Pipeline, "AppPlatformConfigurationServiceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configurationServices/{configurationServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationServices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformConfigurationServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationServiceName"> The name of Application Configuration Service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationServiceName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string configurationServiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationServiceName, nameof(configurationServiceName));

            using var scope = _appPlatformConfigurationServiceConfigurationServicesClientDiagnostics.CreateScope("AppPlatformConfigurationServiceCollection.Exists");
            scope.Start();
            try
            {
                var response = await _appPlatformConfigurationServiceConfigurationServicesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationServiceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configurationServices/{configurationServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationServices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformConfigurationServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationServiceName"> The name of Application Configuration Service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationServiceName"/> is null. </exception>
        public virtual Response<bool> Exists(string configurationServiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationServiceName, nameof(configurationServiceName));

            using var scope = _appPlatformConfigurationServiceConfigurationServicesClientDiagnostics.CreateScope("AppPlatformConfigurationServiceCollection.Exists");
            scope.Start();
            try
            {
                var response = _appPlatformConfigurationServiceConfigurationServicesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationServiceName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configurationServices/{configurationServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationServices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformConfigurationServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationServiceName"> The name of Application Configuration Service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationServiceName"/> is null. </exception>
        public virtual async Task<NullableResponse<AppPlatformConfigurationServiceResource>> GetIfExistsAsync(string configurationServiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationServiceName, nameof(configurationServiceName));

            using var scope = _appPlatformConfigurationServiceConfigurationServicesClientDiagnostics.CreateScope("AppPlatformConfigurationServiceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _appPlatformConfigurationServiceConfigurationServicesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationServiceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<AppPlatformConfigurationServiceResource>(response.GetRawResponse());
                return Response.FromValue(new AppPlatformConfigurationServiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configurationServices/{configurationServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationServices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AppPlatformConfigurationServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationServiceName"> The name of Application Configuration Service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="configurationServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationServiceName"/> is null. </exception>
        public virtual NullableResponse<AppPlatformConfigurationServiceResource> GetIfExists(string configurationServiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(configurationServiceName, nameof(configurationServiceName));

            using var scope = _appPlatformConfigurationServiceConfigurationServicesClientDiagnostics.CreateScope("AppPlatformConfigurationServiceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _appPlatformConfigurationServiceConfigurationServicesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, configurationServiceName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<AppPlatformConfigurationServiceResource>(response.GetRawResponse());
                return Response.FromValue(new AppPlatformConfigurationServiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<AppPlatformConfigurationServiceResource> IEnumerable<AppPlatformConfigurationServiceResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<AppPlatformConfigurationServiceResource> IAsyncEnumerable<AppPlatformConfigurationServiceResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
